/*

Copyright (C) 1998  Paul Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* stack.c  by Paul Wilkins */

#include <stdio.h>
#include <stdlib.h>

#include "stack.h"
#include "number.h"

#define STACK_CHUNK_SIZE 2

/* a stack element */
struct StackElem {
   struct StackElem *t;   /* the node above us */
   struct StackElem *b;   /* the node below us */
   Number *data;          /* the data */
};


/* we build the stack in these arrays */
struct StackChunk {
   int freeIndx;
   struct StackElem *freeList[STACK_CHUNK_SIZE];
   struct StackChunk *next;
   struct StackElem ary[STACK_CHUNK_SIZE];
};

struct StackChunk *stackChunkHead = NULL;

/* the head (bottom) of the stack */
struct StackElem *stackHead;
int stackLength = 0;


/* get the length of the stack */
int stackLen(){
   return stackLength;
}

/* malloc a new stack chunk */
struct StackChunk * newStackChunk(){
   int i;
   struct StackChunk *c;

   /* malloc a new chunk */
   if(NULL == (c=(struct StackChunk *)malloc(sizeof(struct StackChunk)))){
      perror("Malloc");
      exit(0);
   }

   /* initalize stuff */
   c->freeIndx = STACK_CHUNK_SIZE - 1;
   c->next = NULL;

   for(i=0; i<STACK_CHUNK_SIZE; i++){
      c->freeList[i] = &((c->ary)[i]);
      c->ary[i].data = NULL;
   }

   return c;
}

/* malloc a new stack element */
struct StackElem * newStackEle(){
   struct StackElem *s;
   struct StackChunk *c;

   /* find the first stack chunk with free elements */
   for(c=stackChunkHead; c->freeIndx==-1; c=c->next);

   /* get the StackEle */
   s = c->freeList[c->freeIndx];

   c->freeIndx--;

   /* if there are no more free elements */
   if(c->freeIndx < 0){

      c->freeIndx = -1;

      if(c->next == NULL) c->next = newStackChunk();
   }
 
   return s;
}

void stackAddToFreeList(struct StackElem *s){
   struct StackChunk *c;

   for(c=stackChunkHead; c!=NULL; c=c->next)
      if(s >= c->ary && s <= &((c->ary)[STACK_CHUNK_SIZE]))
         c->freeList[++(c->freeIndx)] = s;
}



int setup_stack(){

   stackHead = NULL;
   stackChunkHead = newStackChunk();
   
   return 1;
}

void clearStack(){
   struct StackElem *s;

   for(s=stackHead; s; s=s->t){
      freeNumber(s->data);
      stackAddToFreeList(s);
   }

   stackHead = NULL;
   stackLength = 0;
}

void printStack(){
   char *c;
   struct StackElem *s = NULL;
   struct StackElem *p = NULL;

   /* find the top of the stack */
   for(s=stackHead; s; s=s->t) p = s;

   /* print the numbers starting from the top */
   for(s=p; p; p=p->b){
      c = printNumber(p->data);
      printf("%s\n", c);
      free(c);
   }
}

Number * getStackEle(int which){
   int i;
   struct StackElem *s = NULL;

   if(which < 0 || which >= stackLength) return NULL;

   s = stackHead;
   for(i=0; i<which; i++) s = s->t;

   return s->data;
}

int Push(Number *data){

   struct StackElem *s;

   /* set the stuff in the newly created stack element */
   s = newStackEle();
   s->data = data;
   s->t = stackHead;
   s->b = NULL;

   /* update the stuff in the ele above us */
   if(s->t) s->t->b = s;

   /* update the head */
   stackHead = s;

   stackLength++;

   return 1;  /* success */
}

Number * Pop(){
   Number *ptr;
   struct StackElem *s;

   s = stackHead;

   /* nothing to pop */
   if(s == NULL) return NULL;

   /* update the stuff in the ele above us */
   if(s->t){
      s->t->b = NULL;
      stackHead = s->t;
   } 
   else stackHead = NULL;
   
   ptr = s->data;
   
   stackAddToFreeList(s);

   stackLength--;

   return ptr;
}
