#include "config.h"
#ifdef USE_VGA
#include <stdlib.h>
#include <stdio.h>
#include <vga.h>
#include <vgagl.h>
#include <vgamouse.h>
#include <vgakeyboard.h>
#include "VGAint.h"
#include "image.h"
#include "input.h"
#include "info.h"


#define SIZE1 5
#define SIZE2 (SIZE1+2)

static int vgamode;
static GraphicsContext bscr[2];
static GraphicsContext physicalscreen;
static int lmx;
static int lmy;

extern struct image image;
extern struct info info;
extern struct input input;
/*static int color;*/
/*
unsigned long lvga_color(int r, int g, int b, int nr)
{
	gl_setpalettecolor(color,r,g,b);
	return(0);
}
*/

int lvga_resize(void)
{
	return (1);
}

int lvga_back(int nr)
{
	return (0);
}

int lvga_fore(int nr)
{
	return (0);
}

int dmouse(void)
{
	int x1, y1, w, h, x2, y2;
	if (input.mx != lmx || input.my != lmy) {
		if (lmx > SIZE2)
			x1 = lmx - SIZE2;
		else
			x1 = 0;
		if (lmy > SIZE2)
			y1 = lmy - SIZE2;
		else
			y1 = 0;
		if (lmx < image.width - SIZE2)
			w = 2 * SIZE2 + 1;
		else
			w = image.width - x1;
		if (lmy < image.height - SIZE2)
			h = 2 * SIZE2 + 1;
		else
			h = image.height - y1;
		gl_setcontext(&physicalscreen);
		gl_copyboxfromcontext(&bscr[image.nr_i],
				      x1, y1, w, h, x1, y1);
	}
	lmx = input.mx;
	lmy = input.my;
	if (image.typ == C_SMALL) {
		vga_setcolor(17);
	} else {
		vga_setrgbcolor(0x00, 0x00, 0xf0);
	}
	if (lmx > SIZE1)
		x1 = lmx - SIZE1;
	else
		x1 = 0;
	if (lmy > SIZE1)
		y1 = lmy - SIZE1;
	else
		y1 = 0;
	if (lmx < image.width - SIZE1)
		x2 = lmx + SIZE1;
	else
		x2 = image.width - 1;
	if (lmy < image.height - SIZE1)
		y2 = lmy + SIZE1;
	else
		y2 = image.height - 1;
	vga_drawline(x1, input.my, x2, input.my);
	vga_drawline(input.mx, y1, input.mx, y2);
	return (0);
}

int lvga_swap(void)
{
	gl_setcontext(&physicalscreen);
	gl_copyboxfromcontext(&bscr[image.nr_i],
			      image.swap_xy.x1,
			      image.swap_xy.y1,
			      image.swap_xy.x2 -
			      image.swap_xy.x1,
			      image.swap_xy.y2 -
			      image.swap_xy.y1,
			      image.swap_xy.x1, image.swap_xy.y1);
	mouse_update();
	dmouse();
/*	if(++event->nr_i==NR_IMAGE)
		event->info.nr_i=0;
*/
	image.ready = 0;
	image.to_swap = 0;
	image.new_swap_set = 1;

	return (1);
}

static int vmod(void)
{

	if (320 == image.width && 200 == image.height)
		return G320x200x256;
	if (640 == image.width && 480 == image.height)
		return G640x480x256;
	if (800 == image.width && 600 == image.height)
		return G800x600x256;
	if (1024 == image.width && 768 == image.height)
		return G1024x768x256;
	return -1;
}

int lvga_event(void)
{
	mouse_update();
	keyboard_update();
	input.mx = mouse_getx();
	input.my = mouse_gety();

	input.Buttons = 0;
	input.key_n = 0;
	if (mouse_getbutton() & MOUSE_LEFTBUTTON)
		input.Buttons |= B1;
	else
		input.Buttons &= ~B1;
	if (mouse_getbutton() & MOUSE_MIDDLEBUTTON)
		input.Buttons |= B2;
	else
		input.Buttons &= ~B2;
	if (mouse_getbutton() & MOUSE_RIGHTBUTTON)
		input.Buttons |= B3;
	else
		input.Buttons &= ~B3;

	if (keyboard_keypressed(SCANCODE_ESCAPE)) {
		input.key |= ESC;
		info.events = QUIT;
	} else
		input.key &= ~ESC;

	if (keyboard_keypressed(SCANCODE_CURSORUP))
		input.arrow |= UP;
	else
		input.arrow &= ~UP;

	if (keyboard_keypressed(SCANCODE_CURSORDOWN))
		input.arrow |= DOWN;
	else
		input.arrow &= ~DOWN;

	if (keyboard_keypressed(SCANCODE_CURSORLEFT))
		input.arrow |= LEFT;
	else
		input.arrow &= ~LEFT;

	if (keyboard_keypressed(SCANCODE_CURSORRIGHT))
		input.arrow |= RIGHT;
	else
		input.arrow &= ~RIGHT;

	if (keyboard_keypressed(SCANCODE_P))
		input.key_n = 'p';
	else if (keyboard_keypressed(SCANCODE_R))
		input.key_n = 'r';

/*	event->ready[0] = 1;
 */
	dmouse();
	return (0);
}

int lvga_palette(unsigned int r, unsigned int g, unsigned int b)
{
	static int i = 17;
	i++;
	vga_setpalette(i, r >> 2, g >> 2, b >> 2);
	return i;
}

int lvga_init(void)
{
	vga_modeinfo *v_info;
	int i;


	if (vga_init() != 0)
		return (1);
	if ((vgamode = vga_getdefaultmode()) == -1)
		vgamode = vmod();
	if (vgamode == -1)
		return 1;
	if (vga_hasmode(vgamode) == 0)
		return (1);

	for (i = 0; i < NR_IMAGE; ++i) {
		gl_setcontextvgavirtual(vgamode);
		gl_getcontext(&bscr[i]);
		image.data[i] = bscr[i].vbuf;
	}
	vga_setmode(vgamode);
	gl_setcontextvga(vgamode);
	gl_getcontext(&physicalscreen);


/*	event->depth=bscr[0].bitsperpixel;
 */
	image.height = bscr[0].height;
	image.width = bscr[0].width;
	image.bytes_pixel = bscr[0].bytesperpixel;
	image.bytes_line = bscr[0].bytewidth;

	image.nr_i = 0;
	keyboard_init();
	vga_setmousesupport(1);
	mouse_setxrange(0, image.width - 1);
	mouse_setyrange(0, image.height - 1);
	lmx = 0;
	lmy = 0;
	v_info = vga_getmodeinfo(vgamode);
	switch (v_info->colors) {
	case 256:
		image.typ = C_SMALL;
		break;
	case 32768:
		image.typ = C_REALCOLOR;
		break;
	case 65536:
		image.typ = C_HICOLOR;
		break;
	case 16777216:
		image.typ = C_TRUECOLOR;
		break;
	default:
		return (-1);
	}

	if (image.typ == C_SMALL) {
		vga_setpalette(17, 0x00, 0x00, 0xf0);
	}
	return (0);
}

int lvga_close(void)
{
	int i;
	for (i = 0; i < NR_IMAGE; ++i) {
		gl_freecontext(&bscr[i]);
	}

	gl_freecontext(&physicalscreen);
	keyboard_close();
	vga_setmode(TEXT);
	return (0);
}
#else
void tv()
{;
}
#endif
