#include "config.h"
#ifdef USE_X11
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "image.h"
#include "input.h"
#include "info.h"
#include "win.h"
#include "Xint.h"
#ifndef OPT
#include <assert.h>
#endif


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysymdef.h>
#include <X11/keysym.h>

#define IMAGESHM
#ifdef IMAGESHM
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif

extern struct info info;
extern struct image image;
extern struct input input;

char *dpyname = NULL;
static Display *dpy;
static int screen;
static XSetWindowAttributes attributes;
static unsigned long attr_mask;
static unsigned int class;
static Window parent_window;
static Visual *defaultvisual;
static XVisualInfo *X_Vinfo;
static int depth;
static Colormap defaultcolormap;
static Colormap colormap;
static Window window;
static XClassHint classHint;
static XWMHints *hints;
static Atom wmDeleteWindow;
static GC gc;
static XGCValues xgcvalues;
#if defined (IMAGE)
static XImage *image;
static Drawable Buffer;

#elif defined IMAGESHM
static XImage *ximage[NR_IMAGE];
static XShmSegmentInfo shminfo[NR_IMAGE];
static Drawable Buffer;
static int Completion;
/*static int ready;*/
#endif
static XEvent ev;
/*static XColor color[MAXCOLOR];*/
/*static int color_nr = 0;
 */


/*unsigned long x11_color(int r, int g, int b, int nr)
{
	color[nr].flags = DoRed | DoGreen | DoBlue;
	color[nr].red = r;
	color[nr].green = g;
	color[nr].blue = b;
	XAllocColor(dpy, colormap, &color[nr]);
	++color_nr;
	return (color[nr].pixel);
}
*/

static void x11_clear_img(void)
{
/*	int i;*/
	XClearWindow(dpy, window);
/*	for(i=0;i<NR_IMAGE;i++){
		memset(ximage[i]->data,0x00,(ximage[i]->height-1)
		       *ximage[0]->bytes_per_line);
		       }*/
}


int x11_back(int nr)
{
/*	XSetBackground(dpy, gc, color[nr].pixel);*/
	return 1;
}

int x11_fore(int nr)
{
/*	XSetForeground(dpy, gc, color[nr].pixel);*/
	return 1;
}

static void x11_draw(int x_src, int y_src, int dest_x,
		     int dest_y, unsigned int width, unsigned int height)
{
#ifndef OPT
	assert(x_src >= 0 && x_src <= image.width);
	assert(dest_x >= 0 && dest_x <= image.width);
	assert((width + x_src) >= 0 && (width + x_src) <= image.width);
	assert(y_src >= 0 && y_src <= image.height);
	assert(dest_y >= 0 && dest_y <= image.height);
	assert((height + y_src) >= 0 && (height + y_src) <= image.height);
#endif
	XShmPutImage(dpy, Buffer, gc, ximage[image.nr_i], x_src,
		     y_src, dest_x, dest_y, width, height, True);
	XFlush(dpy);
}

int x11_swap(void)
{

#if defined IMAGE
	XPutImage(dpy, Buffer, gc, ximage, 0, 0, 0, 0, width, height);
#elif defined IMAGESHM
	if (image.ready) {
		x11_draw(image.swap_xy.x1,
			 image.swap_xy.y1, image.swap_xy.x1,
			 image.swap_xy.y1,
			 image.swap_xy.x2 - image.swap_xy.x1,
			 image.swap_xy.y2 - image.swap_xy.y1);
		/*
		 * XSync(dpy, False);
		 */

/*		if(++image.nr_i==NR_IMAGE)
		image.nr_i=0;*/

		/*
		 * XFlush(dpy);
		 */
		image.ready = 0;
		image.to_swap = 0;
		image.new_swap_set = 1;
		return 1;
	}
#endif
	return 0;
}


int x11_resize(void)
{
#ifdef IMAGE
	XDestroyImage(ximage);
	ximage = XCreateImage(dpy, defaultvisual, depth, ZPixmap, 0, NULL,
			      event->width, event->height, 8, 0);
	ximage->data = malloc(ximage->bytes_per_line * event->height);
#elif defined IMAGESHM


	if (!(info.flag & FULL)) {
		int i;
/*		XSync(dpy, 0);
		XResizeWindow(dpy, window,
			      (unsigned int) image.width,
			      (unsigned int) image.height);*/
		for (i = 0; i < NR_IMAGE; ++i) {
			XDestroyImage(ximage[i]);
			XShmDetach(dpy, &shminfo[i]);
			shmdt(shminfo[i].shmaddr);
			/*
			 * shmctl(shminfo[i].shmid, IPC_RMID, 0);
			 * XSync(dpy,0);
			 */
		}
		XSync(dpy, 0);
		for (i = 0; i < NR_IMAGE; ++i) {
			ximage[i] =
			    XShmCreateImage(dpy, defaultvisual, depth,
					    ZPixmap, NULL, &shminfo[i],
					    image.width, image.height);
			shminfo[i].shmid =
			    shmget(IPC_PRIVATE,
				   ximage[i]->bytes_per_line *
				   ximage[i]->height, IPC_CREAT | 0777);
			shminfo[i].shmaddr = ximage[i]->data =
			    shmat(shminfo[i].shmid, 0, 0);
			shminfo[i].readOnly = True;
			XShmAttach(dpy, &shminfo[i]);
			image.data[i] = ximage[i]->data;
		}
		image.bytes_line = ximage[0]->bytes_per_line;
		image.ready = 1;
		info.events |= RESIZE;
		x11_clear_img();
	}
#endif
	XSync(dpy, 0);
	return 0;
}


int x11_event(void)
{
	info.events = 0;
	input.key_n = 0;
	if (XPending(dpy)) {
		do {
			XNextEvent(dpy, &ev);
			switch (ev.type) {
			case ClientMessage:
				if (ev.xclient.format == 32
				    && ev.xclient.data.l[0] ==
				    wmDeleteWindow)
					info.events = QUIT;
				break;
			case MotionNotify:
				input.mx = ev.xmotion.x;
				input.my = ev.xmotion.y;
				input.Buttons = (ev.xmotion.state >> 8)
				    & (B1 | B2 | B3);
				break;
			case ButtonRelease:
				input.mx = ev.xbutton.x;
				input.my = ev.xbutton.y;
				switch (ev.xbutton.button) {
				case 1:
					input.Buttons &= ~B1;
					break;
				case 2:
					input.Buttons &= ~B2;
					break;
				case 3:
					input.Buttons &= ~B3;
					break;
				}
				break;
			case ButtonPress:
				input.mx = ev.xbutton.x;
				input.my = ev.xbutton.y;
				if (input.mx < 0
				    || input.my < 0
				    || input.mx > image.width
				    || input.my > image.height)
					break;
				switch (ev.xbutton.button) {
				case 1:
					input.Buttons |= B1;
					break;
				case 2:
					input.Buttons |= B2;
					break;
				case 3:
					input.Buttons |= B3;
					break;
				}
				break;
			case KeyRelease:
				{
					KeySym ksym;
					switch (ksym =
						XLookupKeysym(&ev.xkey,
							      0)) {
					case XK_Escape:
						input.key &= ~ESC;
						break;
					case XK_Up:
						input.arrow &= ~UP;
						break;
					case XK_Down:
						input.arrow &= ~DOWN;
						break;
					case XK_Left:
						input.arrow &= ~LEFT;
						break;
					case XK_Right:
						input.arrow &= ~RIGHT;
						break;
					}
				}
				break;
			case KeyPress:
				{
					KeySym ksym;
					switch (ksym =
						XLookupKeysym(&ev.xkey,
							      0)) {
					case XK_Escape:
						input.key |= ESC;
						info.events = QUIT;
						break;
					case XK_Up:
						input.arrow |= UP;
						break;
					case XK_Down:
						input.arrow |= DOWN;
						break;
					case XK_Left:
						input.arrow |= LEFT;
						break;
					case XK_Right:
						input.arrow |= RIGHT;
						break;
/*                   case XK_F1:
		     event->events = QUIT;
		     break;*/
					default:{
							char buff1;
							XLookupString(&ev.
								      xkey,
								      &buff1,
								      1,
								      &ksym,
								      NULL);
							input.
							    key_n =
							    (unsigned char)
							    buff1;
						}
						break;
					}
				}
				break;
			case ConfigureNotify:
				{
					int tmp;
					Window wtmp;
					int w1, h1;
					w1 = image.width;
					h1 = image.height;
					XSync(dpy, 0);
					XGetGeometry(dpy, window, &wtmp,
						     &tmp, &tmp,
						     (unsigned int *)
						     &(image.width),
						     (unsigned int *)
						     &(image.
						       height),
						     (unsigned int *) &tmp,
						     (unsigned int *)
						     &tmp);
					if (image.width != w1
					    || image.height != h1) {
						x11_resize();
					}
				}
				break;
			case Expose:
				info.events |= UPDATE;
				XSync(dpy, 0);
				x11_draw(ev.xexpose.x, ev.xexpose.y,
					 ev.xexpose.x, ev.xexpose.y,
					 ev.xexpose.width,
					 ev.xexpose.height);
				break;
			default:
#ifdef IMAGESHM
				if (ev.xany.type == Completion) {
					image.ready = 1;
				}
#endif
				break;
			}
		}
		while (XEventsQueued(dpy, QueuedAlready));
	}
	return 0;
}



int x11_init(void)
{
	extern int XShmGetEventBase();
	enum states { s_dpy, s_info, s_win, s_setup, s_image, s_done,
		s_error
	};
	int state = s_dpy;
	unsigned int x, y, border;
	char buff[255];
	int i;
	int v_num = 0;
	XVisualInfo v_temp;


	while (state < s_done) {
		switch (state) {
		case s_dpy:
			dpyname = &buff[0];
			if ((dpyname = getenv("DISPLAY")) == NULL)
				dpyname = "localhost:0.0";
			if ((dpy = XOpenDisplay(dpyname)) == NULL) {
				if (info.flag & VERBOSE)
					fprintf(stderr,
						"Fail to open Display:\t%s\n",
						dpyname);
				state = s_error;
				break;
			}
			if (info.flag & VERBOSE)
				printf("Open Display:\t%s\n", dpyname);
			state = s_info;
			break;
		case s_info:
			screen = DefaultScreen(dpy);
			attributes.background_pixel =
			    BlackPixel(dpy, screen);
			attributes.border_pixel = BlackPixel(dpy, screen);
			attributes.event_mask = ButtonPressMask
			    | StructureNotifyMask | ButtonReleaseMask |
			    ButtonMotionMask | KeyPressMask | ExposureMask
			    | KeyReleaseMask;
			attr_mask = CWBackPixel | CWEventMask;
			class = InputOutput;
			parent_window = RootWindow(dpy, screen);
			defaultvisual = DefaultVisual(dpy, screen);
			depth = DefaultDepth(dpy, screen);
			defaultcolormap = DefaultColormap(dpy, screen);
			if (info.flag & FULL) {
				attributes.override_redirect = True;
				attr_mask |= CWOverrideRedirect;
				{
					Window wtmp;
					int tmp;
					XGetGeometry(dpy,
						     RootWindow(dpy,
								screen),
						     &wtmp, &tmp, &tmp, &x,
						     &y, &border,
						     (unsigned int *)
						     &tmp);
				}
			} else {
				border = W_BORDER;
				attr_mask |= CWBorderPixel;
				x = image.width;
				y = image.height;
			}
			state = s_win;
			break;
		case s_win:
			window = XCreateWindow(dpy, parent_window, 0, 0,
					       x, y, border, depth, class,
					       defaultvisual,
					       attr_mask, &attributes);

			state = s_setup;
			break;
		case s_setup:
			classHint.res_name = "xrsf";
			classHint.res_class = "xrsf";
			hints = XAllocWMHints();
			hints->initial_state = NormalState;
			hints->window_group = window;
			hints->flags = (WindowGroupHint | StateHint);
			XSetWMProperties(dpy, window, NULL, NULL,
					 NULL, 1, NULL, hints, &classHint);
			XSetIconName(dpy, window, "  xrsf  ");
			wmDeleteWindow =
			    XInternAtom(dpy, "WM_DELETE_WINDOW", False);
			XSetWMProtocols(dpy, window, &wmDeleteWindow, 1);
			gc = XCreateGC(dpy, window, 0L, &xgcvalues);
			XSetBackground(dpy, gc, BlackPixel(dpy, screen));
			XSetForeground(dpy, gc, WhitePixel(dpy, screen));
			XStoreName(dpy, window, "  xrsf  ");
			XMapWindow(dpy, window);
			if (info.flag & FULL)
				XSetInputFocus(dpy, window, RevertToNone,
					       CurrentTime);
			state = s_image;
			break;
		case s_image:
#if defined IMAGE
			ximage = XCreateImage(dpy, defaultvisual, depth,
					      ZPixmap, 0, NULL, x, y, 8,
					      0);
			ximage->data = malloc(ximage->bytes_per_line * y);
			XSetBackground(dpy, gc, 0);
/*	XSetFunction(dpy, gc, GXcopy); */
			Buffer = window;
#elif defined IMAGESHM
			{
				int tmp;
				XQueryExtension(dpy, "MIT-SHM", &tmp, &tmp,
						&tmp);
			}
			for (i = 0; i < NR_IMAGE; ++i) {
				ximage[i] =
				    XShmCreateImage(dpy, defaultvisual,
						    depth, ZPixmap, NULL,
						    &shminfo[i], x, y);
				shminfo[i].shmid =
				    shmget(IPC_PRIVATE,
					   ximage[i]->bytes_per_line *
					   ximage[i]->height,
					   IPC_CREAT | 0777);
				shminfo[i].shmaddr = ximage[i]->data =
				    shmat(shminfo[i].shmid, 0, 0);
				shminfo[i].readOnly = True;
				XShmAttach(dpy, &shminfo[i]);
				image.data[i] = ximage[i]->data;
			}
			XSetBackground(dpy, gc, 0);
/*	XSetFunction(dpy, gc, GXcopy);*/
			Buffer = window;
			Completion = XShmGetEventBase(dpy) + ShmCompletion;
			image.blackpixel = BlackPixel(dpy, screen);
			image.whitepixel = WhitePixel(dpy, screen);
			image.bytes_line = ximage[0]->bytes_per_line;

			/*
			 * event->depth = depth;
			 */
			switch (ximage[0]->bits_per_pixel) {
			case 8:
				image.bytes_pixel = 1;
				break;
			case 16:
				image.bytes_pixel = 2;
				break;
			case 24:
				image.bytes_pixel = 3;
				break;
			case 32:
				image.bytes_pixel = 4;
				break;
			default:
				image.bytes_pixel
				    = ximage[0]->bits_per_pixel / 8;
				break;
			}
			image.nr_i = 0;
			image.ready = 1;
			/*
			 * x11_swap(event);
			 */
#endif
			image.height = y;
			image.width = x;
			/*
			 * height = image.height;
			 * width = image.width;
			 */ colormap =
			    XCreateColormap(dpy, window, defaultvisual,
					    AllocNone);
			v_temp.visualid =
			    XVisualIDFromVisual(defaultvisual);
			X_Vinfo =
			    XGetVisualInfo(dpy, VisualIDMask, &v_temp,
					   &v_num);
			i = 0;

			image.swap_xy.x1 = 0;
			image.swap_xy.y1 = 0;
			image.swap_xy.x2 = image.width;
			image.swap_xy.y2 = image.height;
			state = s_done;
			break;
		default:
			state = s_error;
			break;
		}
	}
	if (state == s_error) {
		return -1;
	}

	switch (ximage[0]->bits_per_pixel) {
	case 8:
		image.typ = C_SMALL;
		break;
	case 15:
		image.typ = C_REALCOLOR;
		break;
	case 16:
		image.typ = C_HICOLOR;
		break;
	case 24:
	case 32:
		image.typ = C_TRUECOLOR;
		break;
	default:
		return (-1);
	}

	x11_clear_img();
	x11_event();
	return 0;
}

int x11_close()
{
/*	unsigned long *pixels;*/
	int i;
/*	pixels = malloc(color_nr);
	for (i = 0; i < color_nr; i++)
		pixels[i] = color[i].pixel;
	XFreeColors(dpy, colormap, pixels, color_nr, 0);
*/
#if defined IMAGE
	XDestroyImage(ximage);
#elif defined IMAGESHM
	for (i = 0; i < NR_IMAGE; ++i) {
		XDestroyImage(ximage[i]);
		XShmDetach(dpy, &shminfo[i]);
		shmdt(shminfo[i].shmaddr);
		shmctl(shminfo[i].shmid, IPC_RMID, 0);
	}
#endif
	XSync(dpy, 0);
	XFreeColormap(dpy, colormap);
	XUnmapWindow(dpy, window);
	XDestroyWindow(dpy, window);
	XCloseDisplay(dpy);
	XFree(X_Vinfo);
	return 0;
}
#else
void tx()
{;
}
#endif
