#include "config.h"
#include <math.h>
#include <float.h>
#include <unistd.h>
#include <stdio.h>
#ifndef OPT
#include <assert.h>
#endif
#include "info.h"
#include "image.h"
#include "engine.h"
#include "mmath.h"
#include "iter.h"
#include "input.h"
#include "set.h"
#include "imtext.h"

#define MAXKA 8
/*8*/

#define MAXITER 70
#define MAXRAGE 4
/* 70 4*/
#define MINITER 2

#define MINFPS 15.0
#define MAXFPS 30.0


extern struct info info;
extern struct input input;

static double zoom = 100.0;
static double dx = 0;
static double dy = 0;
static int ka = MAXKA;
static int kl = MAXKA;
static int mwiter = MAXITER;
static int miter = MAXITER;
static double mrage = MAXRAGE;
static unsigned long textcolor;

#define S 2e-3
#define Z 2e-3

static int run_key(double dt, double fps)
{
	static int run1 = 1;
	switch (input.key_n) {
	case 'p':
		ka = kl;
		mwiter += 10;
		miter = mwiter;
		return 1;
	case 'r':
		ka = kl;
		mwiter -= 10;
		if (mwiter <= MINITER)
			mwiter = MINITER + 5;
		miter = mwiter;
		return 1;
	case 'a':
		break;
	case 'y':
		break;
	default:
		break;
	}
	if (input.Buttons) {
		if (run1) {
			ka = kl;
			run1 = 0;
		}
		if (input.Buttons & B1) {
			zoom *= (1.0 + Z * dt);
		} else if (input.Buttons & B3) {
			zoom /= (1.0 + Z * dt);
			if (zoom <= 0.0001)
				zoom = 0.0001;
		}
		if (input.Buttons & B2) {
			double f = (dt * S) / zoom;
			dx -=
			    (double) (input.mx -
				      (int) image_width() / 2) * f;
			dy -=
			    (double) ((int) image_height() / 2 -
				      input.my) * f;
		}
		if (fps < MINFPS) {
			if (ka < MAXKA)
				ka++;
		} else if (fps > MAXFPS) {
			if (ka > 1)
				ka--;
		}
		kl = ka;
		return 1;
	} else {
		run1 = 1;
		if (ka > 1) {
			ka--;
			return 2;
		}
	}
	return 0;
}



static int init_iter(void)
{
	if (set_iter() != 0)
		return -1;
	textcolor = rgb_conv(0xff, 0xff, 0xff);
	return 0;
}

int init_eng(void)
{
	create_back();
	if (init_iter() != 0)
		return -1;
	image_to_swap(1);
	iter(dx, dy, zoom, 1, 1, miter, mrage, 1);
	return 0;
}

static int print_info(double fps)
{
	int len;
	char buff[255];
	snprintf(buff, 255, "%.2f", fps);
	len = d_string(0, 0, buff, textcolor);
	set_area(0, 0, (TEXT_WIDTH + 2) * 5, TEXT_HEIGHT);
	return len;
}

void run_eng(double dt, double fps)
{
	static int re = 0;

	if ((info.events & UPDATE)) {
		info.events &= ~UPDATE;
	}
	if ((info.events & RESIZE)) {
		re = 1;
		image_to_swap(0);
		return;
	} else if (re == 1) {
		re = 0;
		zoom = 100;
		miter = mwiter;
		mrage = MAXRAGE;
		set_set();
		init_eng();
		return;
	}
	if (!image_swap_status()) {
		static int llen = 0;
		if (info.flag & FPS && llen)
			clear_data(0, 0, (TEXT_WIDTH + 2) * llen,
				   TEXT_HEIGHT);

		switch (run_key(dt, fps)) {
		case 1:
			image_to_swap(1);
			ka = iter(dx, dy, zoom, ka, kl, miter, mrage, 1);
			if (info.flag & FPS)
				llen = print_info(fps);
			break;
		case 2:
			image_to_swap(1);
			if (info.flag & FPS && llen)
				iter_a(dx, dy, zoom, ka, kl, miter, mrage,
				       0, 0, (TEXT_WIDTH + 2) * llen,
				       TEXT_HEIGHT);
			ka = iter(dx, dy, zoom, ka, kl, miter, mrage, 2);
			break;
		default:
			break;
		}
	}
	if ((info.events & RESIZE)) {
		re = 1;
		image_to_swap(0);
	}
}

void end_eng(void)
{
	stop_iter();
}
