#include "iter.h"
#include <stdlib.h>
#include <math.h>
#include "image.h"
#include "mmath.h"
#include "gi.h"
#include "input.h"
#include <stdio.h>
#include "info.h"



#define W1 4
#define H1 4

static int x_1, x_2;
static int y_1, y_2;

extern ginter gi;
extern struct info info;
extern struct input input;


static int maxcolor_table = 0;
static unsigned long *colors = NULL;
static unsigned long color_table[] = {
	0x000000,
	0x000020,
	0x000040,
	0x000060,
	0x000080,
	0x0000A0,
	0x0000C0,
	0x0020A0,
	0x004080,
	0x006060,
	0x008040,
	0x00A020,
	0x00C000,
	0x20A000,
	0x408000,
	0x606000,
	0x804000,
	0xA02000,
	0xC00000
};


static unsigned long getcolor(unsigned long c)
{
	return rgb_conv((c >> 16) & 0xff, (c >> 8) & 0xff, c & 0xff);
}

static int init_color(void)
{
	unsigned long *t;
	int i;
	maxcolor_table = sizeof(color_table) / sizeof(color_table[0]);

	t = realloc(colors,
		    (size_t) (sizeof(unsigned long)) * maxcolor_table);
	if (t == NULL) {
		if (colors != NULL)
			free(colors);
		return -1;
	}
	colors = t;
	for (i = 0; i < maxcolor_table; i++) {
		colors[i] = getcolor(color_table[i]);
	}
	return 0;
}

int set_iter(void)
{
	x_2 = image_width() / 2;
	y_2 = image_height() / 2;
	x_1 = x_2;
	y_1 = y_2;

	if (init_color() != 0)
		return -1;
	return 0;
}


__inline__ static double t_xb(int xa, double dx, int xh, double s)
{
	double x = (double) (xa - xh) / s - (double) dx;
	return x;
}

__inline__ static double t_yb(int ya, double dy, int yh, double s)
{
	double y = -(double) (ya - yh) / s - (double) dy;
	return y;
}


__inline__ static double t_xa(int xb, double dx, int xh, double s)
{
	double x = ((double) xb + dx) * s + (double) xh;
	return x;
}

__inline__ static double t_ya(int yb, double dy, int yh, double s)
{
	double y = -((double) yb + dy) * s + (double) yh;
	return y;
}

#ifdef INTEL_CPU

extern int itplot(double x, double y, int miter, double mrage);

#else

__inline__ static int itplot(double x, double y, int miter, double mrage)
{
	int res = 0;
	double sqra = SQR(x);
	double sqrb = SQR(y);
	double a = x;
	double b = y;
	for (res = 0; mrage > (sqra + sqrb); res++) {
		if (res > miter)
			return 0;
		b = 2 * a * b + y;
		a = sqra + x - sqrb;
		sqra = SQR(a);
		sqrb = SQR(b);
	}
	return res;
}

#endif

__inline__ static void clear_old(int xa1, int xa2, int ya1, int ya2)
{
	int x1 = x_1, y1 = y_1, x2 = x_2, y2 = y_2;

	if (y1 < ya1) {
		y2 = MIN(y2, ya1);
		set_area(x1, y1, x2, y2);
		clear_data(x1, y1, x2, y2);
		if (y2 == y_2)
			return;
		y1 = y2;
		y2 = y_2;
	}
	if (x1 < xa1) {
		x2 = MIN(x2, xa1);
		set_area(x1, y1, x2, y2);
		clear_data(x1, y1, x2, y2);
		if (x2 == x_2)
			return;
		x1 = x2;
		x2 = x_2;
	}
	if (y2 > ya2) {
		y1 = MAX(y1, ya2);
		set_area(x1, y1, x2, y2);
		clear_data(x1, y1, x2, y2);
		if (y1 == y_1)
			return;
		y2 = y1;
		y1 = y_1;
	}
	if (x2 > xa2) {
		x1 = MAX(x1, xa2);
		set_area(x1, y1, x2, y2);
		clear_data(x1, y1, x2, y2);
	}
}


__inline__ static void iter_area(int x0, int y0, int x1, int y1, double xb,
				 double yb, double dxb, double dyb,
				 int miter, double mrage)
{
	for (; x0 < x1; x0++, xb += dxb) {
		double tyb = yb;
		int ty0 = y0;
		for (; ty0 < y1; ty0++, tyb += dyb) {
			unsigned long c;
			int i = itplot(xb, tyb, miter, mrage);
			i = i % maxcolor_table;
			c = colors[i];
			points_matrix(x0, ty0, c);
		}
	}
}

/*
__inline__ static void iter_xline(int x0,int x1,int y,double xb,double yb,double dxb,int miter, double mrage){
	for(;x0<=x1;x0++,xb+=dxb){
		unsigned long c;
		int i = itplot(xb, yb, miter, mrage);
		i = i % maxcolor_table;
		c = colors[i];
		points_matrix(x0, y, c);
	}
}


__inline__ static void iter_yline(int x,int y0,int y1,double xb,double yb,double dyb,int miter, double mrage){
	for(;y0<=y1;y0++,yb+=dyb){
		unsigned long c;
		int i = itplot(xb, yb, miter, mrage);
		i = i % maxcolor_table;
		c = colors[i];
		points_matrix(x, y0, c);
	}
}



__inline__ static unsigned long int iter_one(x,y,miter,mrage){
	int i = itplot(x, y, miter, mrage);
	i = i % maxcolor_table;
	return colors[i];
}


__inline__ static void iter_area_s (int x0,int y0,int x1,int y1,double xb,double yb,double dxb,double dyb,int miter, double mrage,unsigned long int c0,int ka){
	unsigned long int c1,c2,c3;
	double ye=yb+dyb*(ka);
	double xe=xb+dxb*(ka);
	if(x0==x1 || y0==y1)
		return;
		
	c1=iter_one(xb,ye,miter,mrage);
	if(c0!=c1){
		points_matrix(x0, y1, c1);
		iter_xline(x0+1,x1,y1,xb+dxb,ye,dxb,miter,mrage);
		iter_yline(x1,y0,y1-1,xe,yb,dyb,miter,mrage);
		iter_area_s (x0,y0,x1-1,y1-1,xb,yb,dxb,dyb,miter,mrage,c0,ka-1);
		return;
	}
	c2=iter_one(xe,ye,miter,mrage);
	if(c0!=c2){
		points_matrix(x1, y1, c2);
		iter_xline(x0+1,x1-1,y1,xb+dxb,ye,dxb,miter,mrage);
		iter_yline(x1,y0,y1-1,xe,yb,dyb,miter,mrage);
		iter_area_s (x0,y0,x1-1,y1-1,xb,yb,dxb,dyb,miter,mrage,c0,ka-1);
		return;
	}
	c3=iter_one(xe,yb,miter,mrage);
	if(c0!=c2){
		points_matrix(x1, y0, c3);
		iter_xline(x0+1,x1-1,y1,xb+dxb,ye,dxb,miter,mrage);
		iter_yline(x1,y0+1,y1-1,xe,yb+dyb,dyb,miter,mrage);
		iter_area_s (x0,y0,x1-1,y1-1,xb,yb,dxb,dyb,miter,mrage,c0,ka-1);
		return;
	}
}
*/

__inline__ int iter_a(double dx, double dy, double s, int ka, int kl,
		      int miter, double mrage, int xa1, int ya1, int xa2,
		      int ya2)
{
	unsigned long int x, y;
	double dxb = 1.0 / s;
	double dyb = -1.0 / s;
	double xb0 = t_xb(xa1, dx, image_width() / 2, s);
	double yb = t_yb(ya1, dy, image_height() / 2, s);
	set_area(xa1, ya1, xa2, ya2);
	for (y = ya1; y < ya2; y += ka, yb += dyb * ka) {
		double xb = xb0;
		for (x = xa1; x < xa2; x += ka, xb += dxb * ka) {

			unsigned long c;
			int i = itplot(xb, yb, miter, mrage);
			i = i % maxcolor_table;
			/*int i = itplot(xb,yb); */
			c = colors[i];
			/*      points(x, y, c, event); */
			if (ka == 1)
				points_matrix(x, y, c);
			else {
				int kx = ka, ky = ka;
				if (ka + x >= xa2)
					kx = xa2 - x;
				if (ka + y >= ya2)
					ky = ya2 - y;
				arena(x, y, kx, ky, c);
			}
		}
	}
	return ka;
}

__inline__ int iter(double dx, double dy, double s, int ka, int kl,
		    int miter, double mrage, int mode)
{
	double tmp_a =
	    MAX(0, t_xa(-W1 / 2, dx, (int) image_width() / 2, s));
	int xa1 = (int) tmp_a;
	int xa2;
	int ya1;
	int ya2;
	tmp_a =
	    MIN(image_width(),
		t_xa(W1 / 2, dx, (int) image_width() / 2, s));
	xa2 = (int) tmp_a;
	tmp_a = MAX(0, t_ya(H1 / 2, dy, (int) image_height() / 2, s));
	ya1 = (int) tmp_a;
	tmp_a =
	    MIN(image_height(),
		t_ya(-H1 / 2, dy, (int) image_height() / 2, s));
	ya2 = (int) tmp_a;

/*	x_1=min(xa1,x_1);
	y_1=min(ya1,y_1);
	x_2=max(xa2,x_2);
	y_2=max(ya2,y_2);
*/


	if (xa1 < image_width() && xa2 >= 0
	    && ya1 < image_height() && ya2 >= 0) {
		if (mode == 1) {
			iter_a(dx, dy, s, ka, kl, miter, mrage, xa1, ya1,
			       xa2, ya2);
		} else if (mode == 2) {
			unsigned long int x, y;
			double dxb = 1.0 / s;
			double dyb = -1.0 / s;
			double xb0 = t_xb(xa1, dx, image_width() / 2, s);
			double yb = t_yb(ya1, dy, image_height() / 2, s);
			set_area(xa1, ya1, xa2, ya2);

			for (y = ya1; y < ya2; y += ka, yb += dyb * ka) {
				double xb = xb0;
				for (x = xa1; x < xa2;
				     x += ka, xb += dxb * ka) {
					unsigned long int c0 =
					    getpoints(x, y);
					if (x + ka >= xa2
					    || y + ka >= ya2
					    || c0 != getpoints(x + ka, y)
					    || c0 != getpoints(x + ka, y)
					    || c0 != getpoints(x, y + ka)
					    || c0 !=
					    getpoints(x + ka, y + ka)
					    || c0 !=
					    getpoints(x + ka / 2,
						      y + ka / 2))
						iter_area(x, y,
							  MIN(x +
							      ka,
							      xa2),
							  MIN(y +
							      ka,
							      ya2),
							  xb, yb,
							  dxb, dyb,
							  miter, mrage);
				}

				if (y * ka % 25 == 0) {
					gi.get_event();
					if (info.events & RESIZE) {
						image_to_swap(0);
						return ka;
					}
					if (ka < kl && input.Buttons) {
						ka = kl;
						y = ya1;
						xb0 =
						    t_xb(xa1, dx,
							 image_width
							 () / 2, s);
						yb = t_yb(ya1, dy,
							  image_height
							  () / 2, s);
					}

				}
			}
		}
	} else {
		xa1 = 0;
		xa2 = 0;
		ya1 = 0;
		ya2 = 0;
	}

	clear_old(xa1, xa2, ya1, ya2);

	x_1 = xa1;
	y_1 = ya1;
	x_2 = xa2;
	y_2 = ya2;

	return ka;
}


void stop_iter()
{
	if (colors != NULL)
		free(colors);
}
