#include <stdlib.h>
#include "matrix.h"

void free_Matrix(Matrix m)
{
	Matrix tmp = m;
	while (*tmp != NULL) {
		free(*tmp);
		tmp++;
	}
	free(m);
}

static void free1_Matrix(Matrix m, int y)
{
	int i;
	for (i = 0; i < y; i++)
		free(m[i]);
	free(m);
}

void free_VMatrix(VMatrix m)
{
	free(m);
}

VMatrix new_VMatrix(void *f, int lines, int bytes_in_line)
{
	VMatrix res = malloc((lines + 1) * sizeof(*res));
	int i;
	char *fi = f;

	if (res == NULL)
		return NULL_VMATRIX;
	for (i = 0; i < lines; i++) {
		res[i] = (fi + i * bytes_in_line);
	}
	res[lines] = NULL;
	return res;
}

Matrix new_Matrix(int x, int y)
{
	Matrix res = malloc((y + 1) * sizeof(*res));
	int i;
	if (res == NULL)
		return NULL_MATRIX;
	for (i = 0; i < y; i++) {
		res[i] = malloc((x) * sizeof(**res));
		if (res[i] == NULL) {
			free1_Matrix(res, i);
			return NULL_MATRIX;
		}
	}
	res[y] = NULL;
	return res;
}

/*
Matrix add_Matrix(Matrix dest,Matrix m, int x,int y){
	int i,k;
	for(i=0;i<y;i++)
		for(k=0;k<x;k++)
			dest[i][k]+=m[i][k];
	return dest;		
}
*/
