#include <stdio.h>
#include <math.h>
#include "init.h"
#include "gi.h"
#include "timer.h"
#include "prog.h"
#include "engine.h"
#include "image.h"
#include "set.h"
#include "info.h"
#include <unistd.h>


extern ginter gi;
extern struct info info;
extern timer_t(*elapsed_time) ();

int start(int argc, char **argv)
{
	init_set();
	if (init(argc, argv) != 0) {
		return (1);
	}
	if (init_gi() != 0) {
		fprintf(stderr, "init_gi: Fail!\n");
		return (1);
	}
	if (set_set() != 0) {
		return 1;
	}
	if (init_eng() != 0)
		return 1;
	return 0;
}

static double msec(void)
{
	static double t1 = 0;
	double t2 = (double) elapsed_time() / 1e3;
	double dt = t2 - t1;
	t1 = t2;
	return dt;
}


int main_loop()
{
	double dt = 1.0;
	double fps = 1.0;
	msec();
	do {
		gi.get_event();
		run_eng(dt, fps);
		if (image_swap_status()) {
			gi.swap_buffer();
			if (!image_swap_status()) {
				dt = msec();
				fps =
				    (fps + 2.0 * 1.0 / (dt * 1e-3)) / 3.0;
			}
		} else {
			usleep(10000);
			msec();
		}
	} while (!(info.events & QUIT));
	end_eng();
	return 0;
}

int e_close()
{
	close_set();
	if (gi.close_gi() != 0) {
		fprintf(stderr, "close_gi: Fail!\n");
		return (1);
	}
	return 0;
}
