#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "set.h"
#include "info.h"
#include "win.h"
#include "config.h"
#include "image.h"
#include "matrix.h"
#include "input.h"

extern struct info info;
extern struct image image;
struct input input;

void init_set(void)
{
#ifdef USE_X11
	info.drv = X11_DRV;
#elif defined USE_VGA
	info.drv = SVGA_DRV;
#endif
	info.flag = 0x00;
	image.height = W_HEIGHT;
	image.width = W_WIDTH;
	input.key = 0x00;
	input.key_n = 0x00;
	input.arrow = 0x00;
	image.buff_line = NULL;
	image.to_swap = 0;
	info.busy = 0;
	image.swap_xy.x1 = 0;
	image.swap_xy.y1 = 0;
	image.swap_xy.x2 = W_WIDTH;
	image.swap_xy.y2 = W_HEIGHT;
	{
		int i;
		for (i = 0; i < NR_IMAGE; i++)
			image.data2[i].init = 0;
	}
}

static void free_matrix1(void)
{
	int i;

	for (i = 0; i < NR_IMAGE; i++) {
		switch (image.data2[i].init) {
		case DATA_US:
			if (image.data2[i].data.usint !=
			    ((unsigned short int **) 0))
				free_VMatrix((VMatrix) image.
					     data2[i].data.usint);
			break;
		case DATA_UL:
			if (image.data2[i].data.ulint !=
			    (unsigned long int **) 0)
				free_VMatrix((VMatrix) image.
					     data2[i].data.ulint);
			break;
		case DATA_UC:
			if (image.data2[i].data.uchar !=
			    (unsigned char **) 0)
				free_VMatrix((VMatrix) image.
					     data2[i].data.uchar);
			break;

		default:
			break;
		}
	}
}

int set_set(void)
{
	int i;
	if ((image.buff_line =
	     realloc(image.buff_line, image.bytes_line)) == NULL) {
		fprintf(stderr, "buff_line_fail!\n");
		return (1);
	}
	free_matrix1();
	for (i = 0; i < NR_IMAGE; i++) {
		switch (image.bytes_pixel) {
#if(SIZEOF_UNSIGNED_LONG==4)
		case 4:
			image.data2[i].init = DATA_UL;
			image.data2[i].data.ulint =
			    (unsigned long int **) new_VMatrix((void *)

							       image.
							       data[i],
							       image.
							       height + 1,
							       image.
							       bytes_line);
			if (image.data2[i].data.ulint ==
			    (unsigned long int **) 0)
				return 1;
			break;
#endif
#if(SIZEOF_UNSIGNED_SHORT==2)
		case 2:
			image.data2[i].init = DATA_US;
			image.data2[i].data.usint =
			    (unsigned short int **) new_VMatrix((void *)

								image.
								data[i],
								image.
								height + 1,
								image.
								bytes_line);
			if (image.data2[i].data.usint ==
			    (unsigned short int **) 0)
				return 1;

			break;
#endif
		default:
			image.data2[i].init = DATA_UC;
			image.data2[i].data.uchar =
			    (unsigned char **) new_VMatrix((void *)
							   image.
							   data[i],
							   image.
							   height + 1,
							   image.
							   bytes_line);
			if (image.data2[i].data.uchar ==
			    (unsigned char **) 0)
				return 1;
			break;
		}
	}
#ifndef OPT
	if (info.flag & VERBOSE) {
		switch (image.data2[0].init) {
		case DATA_US:
			fprintf(stdout, "ushort\n");
			break;
		case DATA_UL:
			fprintf(stdout, "ulong\n");
			break;
		case DATA_UC:
			fprintf(stdout, "uchar\n");
			break;
		}
	}
#endif
	image.to_swap = 1;
	image.swap_xy.x1 = 0;
	image.swap_xy.y1 = 0;
	image.swap_xy.x2 = image.width;
	image.swap_xy.y2 = image.height;
	image.new_swap_set = 1;
	return 0;
}

void close_set(void)
{
	free(image.buff_line);
	free_matrix1();
}
