#include <sys/time.h>
#include <unistd.h>
#include "timer.h"

static struct timeval t1;
static timer_t elapsed_time_1();
static timer_t elapsed_time_2();
timer_t(*elapsed_time) () = elapsed_time_1;

/*#ifndef __STRICT_ANSI__
#define DTIME(t1,t2)                            \
({unsigned long int __sec,__usec;               \
  if((t2).tv_usec < (t1).tv_usec ){             \
    __usec = (t2).tv_usec-(t1).tv_usec+1000000; \
    __sec  = (t2).tv_sec-(t1).tv_sec  -1;       \
   } else {                                     \
    __usec = (t2).tv_usec-(t1).tv_usec;         \
    __sec  = (t2).tv_sec-(t1).tv_sec;           \
   }                                            \
   __usec+=__sec*1000000;                       \
   __usec;                                      \
})*/
/*
#define DDTIME(t1,t2)                           \
({double __sec,__usec;                          \
  if((t2).tv_usec < (t1).tv_usec ){             \
    __usec = (t2).tv_usec-(t1).tv_usec+1000000; \
    __sec  = (t2).tv_sec-(t1).tv_sec  -1;       \
   } else {                                     \
    __usec = (t2).tv_usec-(t1).tv_usec;         \
    __sec  = (t2).tv_sec-(t1).tv_sec;           \
   }                                            \
  __usec*=0.000001;                             \
   __sec+=__usec;                                      \
  __sec;                                       \
})
*/
/*#else*/
__inline__ static timer_t dtime(struct timeval t1, struct timeval t2)
{
	timer_t sec, usec;
	if (t2.tv_usec < t1.tv_usec) {
		usec = t2.tv_usec - t1.tv_usec + 1000000;
		sec = t2.tv_sec - t1.tv_sec - 1;
	} else {
		usec = t2.tv_usec - t1.tv_usec;
		sec = t2.tv_sec - t1.tv_sec;
	}
	usec += sec * 1000000;
	return usec;
}

#define DTIME(t1,t2) (dtime(t1,t2))
/*#endif*/


static timer_t elapsed_time_1()
{
	static int init = 0;
	struct timeval t2;

	elapsed_time = elapsed_time_2;
	if (init == 0) {
		gettimeofday(&t1, NULL);
		init = 1;
		return 0;
	}
	gettimeofday(&t2, NULL);
	return DTIME(t1, t2);
}

static timer_t elapsed_time_2()
{
	struct timeval t2;
	gettimeofday(&t2, NULL);
	return DTIME(t1, t2);
}
