.TH csim 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
csim - simulation (time response) of linear system
.SH CALLING SEQUENCE
.nf
[y [,x]]=csim(u,t,sl,[x0])
.fi
.SH PARAMETERS
.TP 
u
: function, list or string (control)
.TP 
t
: real vector specifying times  with, \fVt(1)\fR is the initial 
time (\fVx0=x(t(1))\fR).
.TP
sl
: list (\fVsyslin\fR)
.TP
y
: a  matrix such that   \fVy=[y(t(i)]\fR, i=1,..,n
.TP
x
: a  matrix such that   \fVx=[x(t(i)]\fR, i=1,..,n
.SH DESCRIPTION
simulation of the controlled linear system \fVsl\fR.
\fVsl\fR is assumed to be a continuous-time system 
represented by a \fVsyslin\fR list.
.LP
\fVu\fR is the control and \fVx0\fR the initial state.
.LP
\fVy\fR is the output and \fVx\fR the state.
.LP
The control can be:
.LP
1. a function : \fV[inputs]=u(t)\fR
.LP
2. a list : \fVlist(ut,parameter1,....,parametern)\fR such that:
\fVinputs=ut(t,parameter1,....,parametern)\fR (\fVut\fR is a function)
.LP
3. the string \fV"impuls"\fR for impulse response calculation
(here \fVsl\fR is assumed SISO without direct feed through and \fVx0=0\fR)
.LP
4. the string \fV"step"\fR for step response calculation 
(here \fVsl\fR is assumed SISO without direct feed-through and \fVx0=0\fR)
.SH EXAMPLE
.nf
s=poly(0,'s');rand('seed',0);w=ssrand(1,1,3);w('A')=w('A')-2*eye();
t=0:0.05:5;
//impulse(w) = step (s * w)
xbasc(0);xset("window",0);xselect();
plot2d([t',t'],[(csim('step',t,tf2ss(s)*w))',0*t'])
xbasc(1);xset("window",1);xselect();
plot2d([t',t'],[(csim('impulse',t,w))',0*t'])
//step(w) = impulse (s^-1 * w)
xbasc(3);xset("window",3);xselect();
plot2d([t',t'],[(csim('step',t,w))',0*t'])
xbasc(4);xset("window",4);xselect();
plot2d([t',t'],[(csim('impulse',t,tf2ss(1/s)*w))',0*t'])
.fi
.SH SEE ALSO
syslin, dsimul, flts, ltitr, rtitr, ode, impl
