.TH ddp 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
ddp - disturbance decoupling
.SH CALLING SEQUENCE
.nf
[Closed,F,G]=ddp(Sys,zeroed,B1,D1)
[Closed,F,G]=ddp(Sys,zeroed,B1,D1,flag,alfa,beta)
.fi
.SH PARAMETERS
.TP
Sys
: \fVsyslin\fR list containing the matrices \fV(A,B2,C,D2)\fR.
.TP
zeroed 
: integer vector, indices of outputs of \fVSys\fR which are zeroed.
.TP
B1 
: real matrix
.TP
D1
: real matrix. \fVB1\fR and \fVD1\fR have the same number of columns.
.TP
flag
: string \fV'ge'\fR or \fV'st'\fR (default) or \fV'pp'\fR.
.TP
alfa 
: real or complex vector (loc. of closed loop poles)
.TP
beta
: real or complex vector (loc. of closed loop poles)
.SH DESCRIPTION
Exact disturbance decoupling (output nulling algorithm).
Given a linear system, and a subset of outputs, z, which are to
be zeroed, characterize the inputs w of Sys such that the 
transfer function from w to z is zero.
\fVSys\fR is a linear system {A,B2,C,D2} with one input and two outputs 
( i.e.  Sys: u-->(z,y) ), part the following system defined from \fVSys\fR
and \fVB1,D1\fR:
.nf
  xdot =  A x + B1  w + B2  u
     z = C1 x + D11 w + D12 u
     y = C2 x + D21 w + D22 u
.fi
outputs of Sys are partitioned into (z,y) where z is to be zeroed,
i.e. the matrices C and D2 are:
.nf
     C=[C1;C2]         D2=[D12;D22]
     C1=C(zeroed,:)    D12=D2(zeroed,:)
.fi
The matrix \fVD1\fR is partitioned similarly as \fVD1=[D11;D21]\fR
with \fVD11=D1(zeroed,:)\fR.
The control is u=Fx+Gw and one  looks for matriced \fVF,G\fR such that the 
closed loop system: w-->z given by 
.nf
  xdot= (A+B2*F)  x + (B1 + B2*G) w
    z = (C1+D12F) x + (D11+D12*G) w
.fi
has zero transfer transfer function.
.LP
\fVflag='ge'\fR : no stability constraints.
\fVflag='st'\fR : look for stable closed loop system (A+B2*F stable).
\fVflag='pp'\fR : eigenvalues of A+B2*F are assigned to \fValfa\fR and 
\fVbeta\fR.
.LP
Closed is a realization of the \fVw-->y\fR closed loop system
.nf
  xdot= (A+B2*F)  x + (B1 + B2*G) w
    y = (C2+D22*F) x + (D21+D22*G) w
.fi
.LP
Stability (resp. pole placement) requires stabilizability 
(resp. controllability) of (A,B2).
.SH EXAMPLE
.nf
rand('seed',0);nx=6;nz=3;nu=2;ny=1;
A=diag(1:6);A(2,2)=-7;A(5,5)=-9;B2=[1,2;0,3;0,4;0,5;0,0;0,0];
C1=[zeros(nz,nz),eye(nz,nz)];D12=[0,1;0,2;0,3];
Sys12=syslin('c',A,B2,C1,D12);
C=[C1;rand(ny,nx)];D2=[D12;rand(ny,size(D12,2))];
Sys=syslin('c',A,B2,C,D2);
[A,B2,C1,D12]=abcd(Sys12);  //The matrices of Sys12.
alfa=-1;beta=-2;flag='ge';
[X,dims,F,U,k,Z]=abinv(Sys12,alfa,beta,flag);
clean(X'*(A+B2*F)*X)
clean(X'*B2*U)
clean((C1+D12*F)*X)
clean(D12*U);
//Calculating an ad-hoc B1,D1
G1=rand(size(B2,2),3);
B1=-B2*G1;
D11=-D12*G1;
D1=[D11;rand(ny,size(B1,2))];

[Closed,F,G]=ddp(Sys,1:nz,B1,D1,'st',alfa,beta);
closed=syslin('c',A+B2*F,B1+B2*G,C1+D12*F,D11+D12*G);
ss2tf(closed)
.fi
.SH AUTHOR
F.D.
.SH SEE ALSO
abinv, ui_observer






