.TH imrep2ss 4 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
imrep2ss - state-space realization of an impulse response 
.SH CALLING SEQUENCE
.nf
[sl]=imrep2ss(v [,deg])
.fi
.SH PARAMETERS
.TP 10
v 
: vector coefficients of impulse response, \fVv(:,k)\fR is the kth sample
.TP
deg
: integer (order required)
.TP
sl
: \fVsyslin\fR list
.SH DESCRIPTION
Impulse response to linear system conversion (one input).
\fVv\fR must have an even number of columns.
.SH EXAMPLE
.nf
s=poly(0,'s');
H=[1/(s+0.5);2/(s-0.4)]   //strictly proper
np=20;w=ldiv(H('num'),H('den'),np);
rep=[w(1:np)';w(np+1:2*np)'];   //The impulse response
H1=ss2tf(imrep2ss(rep))
z=poly(0,'z');
H=(2*z^2-3.4*z+1.5)/(z^2-1.6*z+0.8)     //Proper transfer function
u=zeros(1,20);u(1)=1;
rep=rtitr(H('num'),H('den'),u);   //Impulse rep. 
//   <=> rep=ldiv(H('num'),H('den'),20)
w=z*imrep2ss(rep)   //Realization with shifted impulse response 
// i.e strictly proper to proper
H2=ss2tf(w);
.fi
.SH SEE ALSO
frep2tf, arl2, time_id, armax, markp2ss, ldiv



