.TH calerf 3 "December 1994" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
calerf -  computes error functions.
.SH CALLING SEQUENCE
 y = calerf(x,flag)
.SH PARAMETERS
.TP
x
: real vector
.TP
flag
: integer indicator 
.TP
y
: real vector (of same size)
.SH DESCRIPTION
 \fVcalerf(x,0)\fR computes the error function:
.IG
.nf
                      /x
     y = 2/sqrt(pi) *|  exp(-t^2) dt
                     /0
.fi
.FI
.LA $$ y = 2/\sqrt{\pi} \int_0^x exp(-t^2)dt $$
 \fVcalerf(x,1)\fR computes the complementary error function:
.IG
.nf
                      /inf
     y = 2/sqrt(pi) *|  exp(-t^2) dt
                     /x
     y= 1 - erf(x)
.fi
.FI
.LA $$ y = 2/\sqrt{\pi} \int_x^\infty exp(-t^2)dt $$
.LA $$y=1-erf(x) $$
 \fVcalerf(x,2)\fR computes the  scaled complementary error function:
.IG
.nf
 	y=exp(x^2)*erfc(x)~(1/sqrt{pi})*1/x for large x.
.fi
.FI
.LA $$ y = exp(x^2) erfc(x) ~ {1 \over x sqrt{\pi} } \mbox{for large x}$$
.SH EXAMPLE
.nf
deff('y=f(t)','y=exp(-t^2)');
calerf(1,0)
2/sqrt(%pi)*intg(0,1,f)
.fi
.SH SEE ALSO
erf, erfc, calerf




