.TH integrate 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
integrate - integration by quadrature
.SH CALLING SEQUENCE
.nf
[x]=integrate(expr,v,x0,x1 [,ea [,er]])
.fi
.SH PARAMETERS
.TP 10
expr
: external Scilab
.TP 10
v
: string (integration variable)
.TP 10
x0,x1
: real numbers (bounds of integration)
.TP 10
ea,er
: real numbers (absolute  error bound) Default value: 0
.TP 10
er
: real number, (relative error bound) Default value: 1.d-8
.SH DESCRIPTION
computes :
.IG
.nf
                      /x1
                     [
                 x = I  f(v)dv
                     ]
                    /x0
.fi
.FI
.LA $$ x = \int_{x_0}^{x_1} f(v)dv $$

The evaluation hopefully satisfies following claim for accuracy:
\fVabs(I-x)<= max(ea,er*abs(I))\fR where I stands for the
exact value of the integral.

.SH EXAMPLE
.nf
integrate('sin(x)','x',0,%pi)
integrate(['if x==0 then 1,';
           'else sin(x)/x,end'],'x',0,%pi)
.fi
.SH SEE ALSO
intg

