.TH contour 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
contour - level curves on a 3D surface
.SH CALLING SEQUENCE
.nf
contour(x,y,z,nz,[theta,alpha,leg,flag,ebox,zlev])
.fi
.SH PARAMETERS
.TP 6
x,y 
: two real row vectors of size n1 and n2.
.TP 6
z   
: real matrix of size (n1,n2), the values of the function.
.TP 6
nz 
: the level values or the number of levels.
.RS
.TP 3
-
If \fVnz\fR is an integer, its value gives the number of level curves 
equally spaced from zmin to zmax.
.TP
-
If \fVnz\fR is a vector, \fVnz(i)\fR gives the value of the ith level curve.
.RE
.TP 6
theta,alpha,leg,flag,ebox
: see \fVplot3d\fR.
.TP 6
zlev
: real number.
.SH DESCRIPTION
\fVcontour\fR draws level curves of a surface z=f(x,y). The level curves are
drawn on a 3D surface. The optional arguments are the same as for the function 
\fVplot3d\fR (except \fVzlev\fR) and their meanings are the same. 
They control the drawing of level curves on a 3D plot.
Only \fVflag(1)=mode\fR has a special meaning.
.RS
.TP 8
mode=0 
: the level curves are drawn on the surface defined by (x,y,z).
.TP
mode=1
: the level curves are drawn on a 3D plot and on the plan defined by 
the equation z=zlev.
.TP
mode=2 
: the level curves are drawn on a 2D plot.
.RE

You can change the format of the floating point number printed on the levels
by using \fVxset("fpf",string)\fR where \fVstring\fR gives the 
format in C format syntax (for example \fVstring="%.3f"\fR). Use 
\fVstring=""\fR to switch back to default format.

Usually we use \fVcontour2d\fR to draw levels curves on a 2D plot.

Enter the command \fVcontour()\fR to see a demo.
.SH EXAMPLE
.nf
t=%pi*[-10:10]/10;
deff("[z]=surf(x,y)","z=sin(x)*cos(y)"); z=feval(t,t,surf);
rect=[-%pi,%pi,-%pi,%pi,-1,1];
contour(t,t,z,10,35,45," ",[0,1,0],rect)
// changing the format of the printing of the levels
xset("fpf","%.2f")
xbasc()
contour(t,t,z,10,35,45," ",[0,1,0],rect)
.fi
.SH SEE ALSO
contour2d, fcontour, fcontour2d, plot3d, xset
.SH AUTHOR
J.Ph.C.
