.TH xset 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
xset - set values of the graphics context
.SH CALLING SEQUENCE
.nf
xset(choice-name,x1,x2,x3,x4,x5)
xset()
.fi
.SH PARAMETERS
.TP 13
choice-name
: string
.TP 13
x1,...,x5
: depending on \fVchoice-name\fR
.TP
xset("alufunction",number)
: Used to set the logical function for drawing. It works only under X11.
The logical function used is set by \fVx1\fR.
src is the source ie what we want to draw.
dst is the destination ie what is already drawn where we want to draw.

Usual values are: 3 for copying (default), 6 for animation and 0 for clearing.

.RS
 0: clear ie "0"
.RE
.RS
 1: and ie "src AND dst"
.RE
.RS
 2: and reverse ie "src AND NOT dst"
.RE
.RS
 3: copy ie "src"
.RE
.RS
 4: and inverted ie "(NOT src) AND dst"
.RE
.RS
 5: noop ie "dst"
.RE
.RS
 6: xor ie "src XOR dst"
.RE
.RS
 7: or ie "src OR dst"
.RE
.RS
 8: nor ie "(NOT src) AND (NOT dst)"
.RE
.RS
 9: equiv ie "(NOT src) XOR dst"
.RE
.RS
10: invert ie "NOT dst"
.RE
.RS
11: or reverse ie "src OR (NOT dst)"
.RE
.RS
12: copy inverted ie "NOT src"
.RE
.RS
13: or inverted ie "(NOT src) OR dst"
.RE
.RS
14: nand ie "(NOT src) OR (NOT dst)"
.RE
.RS
15: set ie "1"
.RE
.TP
xset("auto clear","on"|"off")
: Switch "on" or "off" the auto clear mode for graphics.
When the auto clear mode is "on", successive plots are not superposed, ie
an \fVxbasc()\fR operation (the graphics
window is cleared and the associated recorded graphics is erased) is 
performed before each high level graphics function. Default value is "off".
.TP
xset("background",color)
: Set the background color of the current graphics window.
.TP
xset("clipping",x,y,w,h) 
: Set the clipping
zone (the zone of the graphics window where plots can be drawn)
to the rectangle (x,y,w,h) (Upper-Left point Width Height).
This function uses the current coordinates of the plot.
.TP
xset("colormap",cmap)
: Set the colormap as a m x 3 matrix. m is the number of colors.
Color number i is given as a 3-uple cmap(i,1), cmap(i,2), cmap(i,3)
corresponding respectively to red, green and blue intensity between
0 and 1.
.TP
xset("dashes",i)
: Set the dash style to style i (0 for solid line). This is used only when in 
black and white mode: \fVxset("use color",0)\fR. Use \fVxset()\fR to see 
the styles.
.TP
xset("default")
: Reset the graphics context to default values.
.TP
xset("font",fontid,fontsize)
: Set the current font and its current size.
.TP
xset("foreground",color)
: Set the foreground color of the current graphics window.
.TP
xset("fpf",string)
: Set the floating point format for number display in 
contour functions. \fVstring\fR is a string giving the format 
in C format syntax (for example \fVstring="%.3f"\fR). Use 
\fVstring=""\fR to switch back to default format.
.TP
xset("hidden3d",colorid)
: Set the color number for hidden faces in \fVplot3d\fR.
.TP
xset("line mode",type)
: This function is used to set the line drawing mode. Absolute mode is set 
with type=1 and relative mode with type=0. (Warning: the mode type=0 has bugs)
.TP
xset("mark",markid,marksize)
: Set the current mark and the current mark size. Use \fVxset()\fR
to see the marks.
.TP
xset("pattern",value)
: Set the current pattern for filling functions. value is an integer 
projected in the interval [0,whiteid]. 0 is used for black filling and 
whiteid for white. The value of whiteid can be obtained with 
\fVxget("white")\fR.
.TP
xset("pixmap",flag)

If flag=0 the graphics are directly displayed on the screen.

If flag=1 the graphics are done on a pixmap and are sent to the
graphics window with the command \fVxset("wshow")\fR. The pixmap is
cleared with the  command \fVxset("wwpc")\fR. Note that the usual command
\fVxbasc()\fR also clears the pixmap.
.TP
xset("thickness",value)
: Set the thickness of lines in pixel  (0 and 1 have the same meaning: 1 pixel thick).
.TP
xset("use color",flag)

If flag=1 then \fVxset("pattern",.)\fR or \fVxset("dashes",.)\fR will be 
used so
as to change the default color for drawing or for filling patterns.

If flag=0 then we switch back to the gray and dashes mode.
.TP
xset("viewport",x,y)
: Set the position of the panner.
.TP
xset("wdim",width,height)
: Set the width and the height of the current graphics window.
This option is not
used by the postscript driver.
.TP
xset("window",window-number)
: Set the current window to the window \fVwindow-number\fR and creates the
window if it does not exist.
.TP
xset("wpos",x,y)
: Set the position of the upper left point of the graphics window.
.TP
xset("wresize",flag)

If flag=1 then the graphic is automatically resized to fill the
graphics window.
.nf
xdel();xset("wresize",1);plot2d();xset("wdim",1000,500)
.fi

If flag=0 the scale of the graphic is left unchanged when the graphics
window is resized. Top left panner or keyboard arrows may be used to
scroll over the graphic.
.nf
xdel();plot2d();xset("wresize",0);xset("wdim",1000,500)
.fi
.TP 
xset("wshow")
: See \fVxset("pixmap",1)\fR above.
.TP
xset("wwpc")
: See \fVxset("pixmap",1)\fR above.
.SH DESCRIPTION
\fVxset\fR is used to set values of the graphics context. When called 
no argument, a choice menu is created showing the current values and 
changes can be performed through toggle buttons.
.SH SEE ALSO
colormap, xget, getcolor, getsymbol
.SH AUTHOR
J.Ph.C.
