.TH xsetech 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
xsetech - set the sub window of a graphics window for plotting
.SH CALLING SEQUENCE
.nf
xsetech(wrect,[frect,logflag])
.fi
.SH PARAMETERS
.TP 9
wrect
: vector of size 4, defining the sub window.
.TP 10
frect
: vector of size 4.
.TP 10
logflag
: string of size 2 "xy", where x and y can be "n" or "l". "n" stands for 
normal and "l" stands for logscale. x stands for the x-axis and y stands
for the y-axis.
.SH DESCRIPTION
.LP
\fVxsetech\fR is mainly used to set the sub window of the graphics window 
which will be used for plotting. The sub window is specified with the 
parameter \fVwrect=[x,y,w,h]\fR (upper-left point, width, height). 
The values in \fVwrect\fR are specified using proportion of the width 
or height of the current graphic window. For instance
\fVwrect=[0,0,1,1]\fR means that the whole graphics window will be used, and
\fVwrect=[0.5,0,0.5,1]\fR means that the graphics region will be the right 
half of the graphics window.

\fVxsetech\fR also set the current graphics scales for 2D plotting
and can be used in conjunction with graphics routines which request
the current graphics scale (for instance \fVstrf="x0z"\fR in \fVplot2d\fR).

\fVfrect=[xmin,ymin,xmax,ymax]\fR is used to set the graphics scale and 
is just like the \fVrect\fR argument of \fVplot2d\fR. Its default value 
is \fV[0,0,1,1]\fR.
.SH EXAMPLE
.nf 
// Here xsetech is used to split the graphics window in two parts 
// first xsetech is used to set the first sub window 
// and the graphics scale 
xsetech([0,0,1.0,0.5],[-5,-3,5,3])
// we call plot2d with the "001" option to use the graphics scale 
// set by xsetech 
plot2d([1:10]',[1:10]',1,"001"," ")
// then xsetech is used to set the second sub window 
xsetech([0,0.5,1.0,0.5])
// the graphics scale is set by xsetech to [0,0,1,1] by default 
// and we change it with the use of the rect argument in plot2d 
plot2d([1:10]',[1:10}',1,"011"," ",[-6,-6,6,6])

// Four plots on a single graphics window 
xbasc()
xset("font",2,0)
xsetech([0,0,0.5,0.5]); plot3d()
xsetech([0.5,0,0.5,0.5]); plot2d()
xsetech([0.5,0.5,0.5,0.5]); grayplot()
xsetech([0,0.5,0.5,0.5]); histplot()
// back to default values for the sub window 
xsetech([0,0,1,1])
xset("default")
.fi
.SH SEE ALSO
isoview, square, xgetech
.SH AUTHOR
J.Ph.C.
