.TH shortest_path 1 "September 1995" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
shortest_path - shortest path
.SH CALLING SEQUENCE
.nf
[p,lp] = shortest_path(i,j,g,[typ])
.fi
.SH PARAMETERS
.TP 2
i
: integer, number of start node
.TP 2
j
: integer, number of end node
.TP 2
g
: graph list
.TP 4
typ
: string, type of shortest path
.TP 2
p
: row vector of integer numbers of the arcs of the shortest path if it exists
.TP 3
lp
: length of shortest path
.SH DESCRIPTION
\fVshortest_path\fR returns the shortest path \fVp\fR from node
\fVi\fR to node \fVj\fR if it exists, and the empty vector \fV[]\fR
otherwise.
The optional argument \fVtyp\fR is a string which defines the type of
shortest path, 'arc' for the shortest path with respect to the number of arcs
and 'length' for the shortest path with respect to the length of the edges 
\fVedge_length\fR.

For the shortest path with respect to the length of the edges, the
lengths are given by the element \fVedge_length\fR of the 
graph list. If its value is not given (empty vector \fV[]\fR), it is assumed 
to be equal to 0 on each edge.
Lengths can be positive, equal to 0 or negative.

When a shortest path exists, \fVlp\fR is the length of this path.
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 4 5 6 6 6 7 7 7 8 9 10 12 12 13 13 13 14 15 14 9 11 10];
he=[2 6 3 4 5 1 3 5 1 7 10 11 5 8 9 5 8 11 10 11 9 11 15 13 14 4 6 9 1];
g=make_graph('foo',1,15,ta,he);
g('node_x')=[194 191 106 194 296 305 305 418 422 432 552 550 549 416 548]; 
g('node_y')=[56 181 276 278 276 103 174 281 177 86 175 90 290 397 399];
show_graph(g);
g1=g;ma=prod(size(g1('head')));
rand('uniform');
g1('edge_length')=int(20*rand(1,ma));
[p,lp]=shortest_path(13,1,g1,'length');
p
x_message(['Showing the arcs of the shortest path ';
           'Choose ""Display arc names"" in the Graph menu to see arc names']);
g1('edge_name')=string(g1('edge_length'));
edgecolor=ones(1:ma);edgecolor(p)=11*ones(p);
g1('edge_color')=edgecolor;
edgefontsize=12*ones(1,ma);edgefontsize(p)=18*ones(p);
g1('edge_font_size')=edgefontsize;
show_graph(g1);
.fi
.SH SEE ALSO
find_path, nodes_2_path
