.TH getdate 1 "Jun 1999" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
getdate - get date and time information
.SH CALLING SEQUENCE
.nf
dt=getdate()
.fi
.SH PARAMETERS
.TP
dt
: an integer vector with 9 entries
.SH DESCRIPTION
dt=getdate() returns
.TP
dt(1)
: The year  as a number (with the century) between 0000 and 9999.
.TP
dt(2)
: The month of the year as a number between 01 and 12.
.TP
dt(3)
: The week number of the year (Monday as the first day of the week).
a decimal number between 1 and 53.  If the week containing January 1
has four or more days in the new year, then it is considered week 1;
otherwise, it is week 53 or the previous year, and the next week is
week 1.
.TP
dt(4)
: The Julian day of the year  as a number between 001 and 366.
.TP
dt(5)
: Specifies the weekday as a decimal number [1,7], with 1 representing
Monday. 
.TP
dt(6)
: The day of the month as a number between 01 and 31.
.TP
dat(7)
: The hour of the day  as a number between 00 and 23.
.TP
dt(8)
: The minute  as a number between 00 and 59.
.TP
dt(9)
: The second is output as a number between 00 and 61.
.SH EXAMPLES
.nf
w=getdate()
mprintf("Year:%d,Month:%d,Day%d",w(1),w(2),w(7));
.fi
.SH SEE ALSO
date, timer

