.TH mfscanf 1 "May 1999" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
 mscanf  - interface to the C scanf function 
 mfscanf - interface to the C fscanf function 
 msscanf - interface to the C sscanf function 
.SH CALLING SEQUENCE
.nf
[n,v_1,...v_n]=mfscanf(fd,format)
L=mfscanf(fd,format)

[n,v_1,...v_n]=mscanf(format)
L=mscanf(format)

[n,v_1,...v_m]=msscanf(format,str)
L=msscanf(format)
.fi
.SH PARAMETERS
.TP 7
format
: a Scilab string describing  the
format to use to write  the  remaining  operands. 
The format operand follows, as close as possible, 
the C printf format operand syntax. 
.TP
fd
:The fd parameter returned by the function \fVmopen\fR is used as a
file descriptor (it's a positive integer). When specifying the fd
parameter, the value -1 refers to the default file ( i.e the last
opened file).
.TP
str
: a Scilab string.
.TP
n
: an integer, the number of data read or -1 if EOL has been
encountered before any datum has been read.
.TP
v_i
: Each function reads characters, interprets them according to
a  format,  and  stores  the results in its output arguments. 
If more than $n$ output arguments are provided, the last ones 
\fVv_n+1,...v_m\fR are set to empty matrices.
.TP
L
: a list of the  \fVv_1,...,v_n \fR variables or -1 if EOL has been
encountered before any datum has been read.
.SH DESCRIPTION
The \fVmfscanf\fR function reads characters from the stream \fVfd\fR.
.LP
The \fVmscanf\fR function reads characters from Scilab window. 
.LP
The \fVmsscanf\fR function reads characters from the Scilab string \fVstr\fR.

.SH EXAMPLES
.nf
s='1 1.3'
[n,a,b]=msscanf(s,"%i %e")
msscanf(s,"%i %e")


msscanf(' 12\n','%c%c%c%c') //scan characters

msscanf('0xabc','%x') //scan with hexadecimal format


msscanf('012345abczoo','%[0-9abc]%s')  //[] notation

//create a file with data
u=mopen(TMPDIR+'/foo','w');
t=0.5;mfprintf(u,'%6.3f %6.3f\n',t,sin(t))
t=0.6;mfprintf(u,'%6.3f %6.3f\n',t,sin(t))
mclose(u);
//read the file
u=mopen(TMPDIR+'/foo','r');
[n,a,b]=mfscanf(u,'%e %e')
l=mfscanf(u,'%e %e')
mclose(u);
.fi

.SH SEE ALSO
mclose, meof, mfprintf, fprintfMat, mfscanf, fscanfMat, mget, mgetstr, mopen, mprintf, mput, mputstr, mscanf, mseek, mtell

