.TH czt 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
czt - chirp z-transform algorithm
.SH CALLING SEQUENCE
.nf
[czx]=czt(x,m,w,phi,a,theta)
.fi
.SH PARAMETERS
.TP 10
x
: input data sequence
.TP
m
: czt is evaluated at \fVm\fR points in z-plane
.TP
w
: magnitude multiplier
.TP
phi
: phase increment
.TP
a
: initial magnitude
.TP
theta
: initial phase
.TP
czx
: chirp z-transform output
.SH DESCRIPTION
chirp z-transform algorithm which calcultes the
z-transform on a spiral in the z-plane at the points
.LP
.Vb [a*exp(j*theta)][w^kexp(j*k*phi)]
for \fVk=0,1,...,m-1\fR.
.SH EXAMPLE
.nf
a=.7*exp(%i*%pi/6);
[ffr,bds]=xgetech(); //preserve current context
rect=[-1.2,-1.2*sqrt(2),1.2,1.2*sqrt(2)];
t=2*%pi*(0:179)/179;xsetech([0,0,0.5,1]);
plot2d(sin(t)',cos(t)',[2],"012",' ',rect)
plot2d([0 real(a)]',[0 imag(a)]',[3],"000")
xsegs([-1.0,0;1.0,0],[0,-1.0;0,1.0])
w0=.93*exp(-%i*%pi/15);w=exp(-(0:9)*log(w0));z=a*w;
zr=real(z);zi=imag(z);
plot2d(zr',zi',[5],"000")
xsetech([0.5,0,0.5,1]);
plot2d(sin(t)',cos(t)',[2],"012",' ',rect)
plot2d([0 real(a)]',[0 imag(a)]',[-1],"000")
xsegs([-1.0,0;1.0,0],[0,-1.0;0,1.0])
w0=w0/(.93*.93);w=exp(-(0:9)*log(w0));z=a*w;
zr=real(z);zi=imag(z);
plot2d(zr',zi',[5],"000")
xsetech(ffr,bds); //restore context
.fi
.SH AUTHOR
C. Bunks
