/*
    ansi.c -- ANSI emulation code
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <ncurses.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include "screen.h"
#include "modem.h"

#define ESC 0x1B
#define Brak '['

/* Global vars */
int InANSI = 0, GotBrak = 0;
int ANSIVal[10], ValCounter = 0;
int SaveX = 0, SaveY = 0, Savepos;
int CurrentFor = COLOR_WHITE+30, CurrentBg = COLOR_BLACK+40;
int attr=0, Clean;

void GetVals()
{
 int i,startpos;
 char tempstr[10];
 
 ValCounter = 0;
 for (i=Savepos+2, startpos=Savepos+2;i<Emupos;i++)
     if (Emu[i] == ';' || i+1 == Emupos)
     {
      if (i+1 == Emupos)
      {
         strncpy(tempstr,&Emu[startpos], i-startpos+1);
         tempstr[i-startpos+1]=0;
      }
      else
      {
         strncpy(tempstr,&Emu[startpos], i-startpos);
         tempstr[i-startpos]=0;
      }
      startpos=i+1;
      ANSIVal[ValCounter++] = atoi(tempstr);
     }
 return;
}

int ANSI(unsigned int ch)
{
 int i;
 int row, col;
 char tempstr[10];

 Clean = 0; 
 if (!InANSI)
 {
  if (ch == ESC) InANSI = 1;
  else
//      swaddch(Screen,(unsigned char)ch);
      return SEND;
 }
 else
 {
  if (!GotBrak)
  {
   if (ch == Brak)
   { 
     GotBrak = 1;
     Savepos = Emupos-1;
     return SAVE;
   }
   else
   {
    //   swaddch(Screen, (unsigned char)ch);
       InANSI = 0;
       swaddch(Screen, ESC);
       return SEND;
   }
  }
  else
  {
    switch(ch){
    case 'H':
     SetCurs:
    GetVals();
    getyx(Screen, row, col);
    if (ValCounter == 2)
    {
     row = ANSIVal[0]-1;
     col = ANSIVal[1]-1;
    }
    else
    if (ValCounter == 1){
     row = ANSIVal[0]-1;
     col = 0;
    }
    else
    {
     row = 0; col = 0;
    }
    if (row == LINES-1) row = LINES-2;
    swmove(Screen, row, col);
//    wrefresh(Screen);
    InANSI = 0; GotBrak = 0; Emupos = Savepos; Clean = 1;
    break;
    case 'f': goto SetCurs;break;
    case 'A':
    GetVals();
    getyx(Screen,row, col);
    if (ValCounter > 0)
    {
     row -= ANSIVal[0];
    }
    else row--;
    swmove(Screen, row, col);
    InANSI = 0; GotBrak = 0; Emupos = Savepos; Clean = 1;
    break;
    case 'B':
    GetVals();
    getyx(Screen,row, col);
    if (ValCounter > 0)
    {
     row += ANSIVal[0];
    }
    else row++;
    swmove(Screen, row, col);
    InANSI = 0; GotBrak = 0; Emupos = Savepos; Clean = 1;
    break;
    case 'C':
    GetVals();
    getyx(Screen,row, col);
    if (ValCounter > 0)
    {
     col += ANSIVal[0];
    }
    else col++;
    swmove(Screen, row, col);
    InANSI = 0; GotBrak = 0; Emupos = Savepos; Clean = 1;
    break;
    case 'D':
    GetVals();
    getyx(Screen,row, col);
    if (ValCounter > 0)
    {
     col -= ANSIVal[0];
    }
    else col--;
    swmove(Screen, row, col);
    InANSI = 0; GotBrak = 0; Emupos = Savepos; Clean = 1;
    break;
    case 'J':
    swclear(Screen);
    InANSI = 0; GotBrak = 0; Emupos = Savepos; Clean = 1;
    break;
    case 'K':
    swclrtoeol(Screen);
    InANSI = 0; GotBrak = 0; Emupos = Savepos; Clean = 1;
    break;
    case 'n':
    getyx(Screen, row, col);
    sprintf(tempstr, "\33[%d;%dR", row, col);
    mwriteblock(tempstr, strlen(tempstr));
    InANSI = 0; GotBrak = 0; Emupos = Savepos; Clean = 1;
    break;
    case 's':
    getyx(Screen, SaveY, SaveX);
    InANSI = 0; GotBrak = 0; Emupos = Savepos; Clean = 1;
    break;
    case 'u':
    swmove(Screen, SaveY, SaveX);
    wrefresh(Screen);
    InANSI = 0; GotBrak = 0; Emupos = Savepos; Clean = 1;
    break;
    case 'm':
    GetVals();
    if (ValCounter > 0)
    {
     for (i=0; i<ValCounter; i++)
     {
      switch(ANSIVal[i]){
      case 0:
      CurrentFor = 37;
      CurrentBg = 40;
      wattrset(Screen,COLOR_PAIR(colortoattr(CurrentFor-30)+8*colortoattr(CurrentBg-40))|A_NORMAL|A_ALTCHARSET);
      attr = A_NORMAL;
      break;
      case 1: 
      wattrset(Screen,COLOR_PAIR(colortoattr(CurrentFor-30)+8*colortoattr(CurrentBg-40))|A_ALTCHARSET|A_BOLD);
      attr = A_BOLD;
      break;
      case 4:
      wattrset(Screen,COLOR_PAIR(colortoattr(CurrentFor-30)+8*colortoattr(CurrentBg-40))|A_ALTCHARSET|A_UNDERLINE);
      attr = A_UNDERLINE;
      break;
      case 5:
      wattrset(Screen,COLOR_PAIR(colortoattr(CurrentFor-30)+8*colortoattr(CurrentBg-40))|A_ALTCHARSET|A_BLINK);
      attr = A_BLINK;
      break;
      case 7:
      wattrset(Screen,COLOR_PAIR(colortoattr(CurrentFor-30)+8*colortoattr(CurrentBg-40))|A_ALTCHARSET|A_REVERSE);
      attr = A_REVERSE;
      break;
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 37:
      wattrset(Screen,COLOR_PAIR(colortoattr(ANSIVal[i]-30)+8*colortoattr(CurrentBg-40))|attr|A_ALTCHARSET);
      CurrentFor = ANSIVal[i];
      break;
      case 40:
      case 41:
      case 42:
      case 43:
      case 44:
      case 45:
      case 46:
      case 47:
      wattrset(Screen,COLOR_PAIR(colortoattr(CurrentFor-30)+8*colortoattr(ANSIVal[i]-40))|attr|A_ALTCHARSET);
      CurrentBg = ANSIVal[i];
      break;
      default:break;
      }/*Switch*/
      }/*For*/
      }/*If*/
/*      wattrset(Screen, COLOR_PAIR(CurrentFor-30+8*(CurrentBg-40)) | attr);*/
      InANSI = 0; GotBrak = 0; Emupos = Savepos; Clean = 1;
      break;
      case 'h':
      strncpy(tempstr, &Emu[Savepos+1], 2);
      tempstr[2]=0;
      if (tempstr=="=7") scrollok(Screen, FALSE);
      if (tempstr=="?7") scrollok(Screen, TRUE);
      InANSI = 0; GotBrak = 0; Emupos = Savepos; Clean = 1;
      break;
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
      case ';': break;
    default:InANSI = 0; GotBrak = 0; Emupos = Savepos; break;
    };
  };
 }
 if (Clean) return DUMP;
 else  if (InANSI) return SAVE;
 else return SEND;
};
