/*
    config.h -- Header file for configuration parser
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef __CONFIG_H_
#define __CONFIG_H_

#define cPhoneText	0x01
#define cPhoneBar	0x02
#define cStatus		0x03
#define cStatusBold	0x04
#define cTerminal	0x05
#define cRemote		0x06
#define cLocal		0x07
#define cInfo		0x08
#define cInfoBold	0x09
#define cHelp		0x0A
#define cHelpBold	0x0B
#define cEdit		0x0C
#define cMenu		0x0D
#define cMenuText	0x0E
#define cMenuTextBold	0x0F
#define cMenuOptions	0x10
#define cMenuTitle	0x11
#define cMenuHot	0x12
#define cMenuBar	0x13
#define ScrollBackSize	0x14
#define LoopDelay	0x15
#define TagChar		0x16
#define EditBack	0x17
#define OnlineWarn	0x18
#define StatusStartOff	0x19
#define StatusStartOn	0x1A
#define StatusEndOff	0x1B
#define StatusEndOn	0x1C
#define AskDevice	0x1D
#define StartInPhone	0x1E
#define StartInTop	0x1F
#define AskCurrentPhone	0x20
#define PhoneBookOnDrop	0x21
#define OpenLog		0x22
#define AutoOpenCapture	0x23
#define AppendCapture	0x24
#define SaveControl	0x25
#define CaptureKeys	0x26
#define HidePwds	0x27
#define AskOnExit	0x28
#define AskOnHang	0x29
#define TagAdvance	0x2A
#define SendAllInit	0x2B
#define DialTime	0x2C
#define DialDelay	0x2D
#define AutoAnswer	0x2E
#define ForceInit	0x2F
#define GlobalLocalEcho	0x30
#define GlobalStripHigh	0x31
#define FileMgrSort	0x32
#define BSdest		0x33
#define DumpVar		0x34
#define DefaultDevice	0x35
#define Parities1	0x36
#define Parities2	0x37
#define Parities3	0x38
#define Parities4	0x39
#define Stopbits1	0x3A
#define Stopbits2	0x3B
#define Stopbits3	0x3C
#define Stopbits4	0x3D
#define Databits1	0x3E
#define Databits2	0x3F
#define Databits3	0x40
#define Databits4	0x41
#define FlowCtrl1	0x42
#define FlowCtrl2	0x43
#define FlowCtrl3	0x44
#define FlowCtrl4	0x45
#define Bauds1		0x46
#define Bauds2		0x47
#define Bauds3		0x48
#define Bauds4		0x49
#define ProtocolAsk1	0x4A
#define ProtocolAsk2	0x4B
#define ProtocolAsk3	0x4C
#define ProtocolAsk4	0x4D
#define ProtocolAsk5	0x4E
#define ChangeDl1	0x4F
#define ChangeDl2	0x50
#define ChangeDl3	0x51
#define ChangeDl4	0x52
#define ChangeDl5	0x53
#define ChangeUl1	0x54
#define ChangeUl2	0x55
#define ChangeUl3	0x56
#define ChangeUl4	0x57
#define ChangeUl5	0x58
#define PhoneType	0x59
#define EscType		0x5A

#define DownloadPath	0x01
#define UploadPath	0x02
#define CapturePath	0x03
#define ScriptPath	0x04
#define PhonePath	0x05
#define LogName		0x06
#define Macro1		0x07
#define Macro2		0x08
#define Macro3		0x09
#define Macro4		0x0A
#define Macro5		0x0B
#define Macro6		0x0C
#define Macro7		0x0D
#define Macro8		0x0E
#define Macro9		0x0F
#define Macro0		0x10
#define ProtocolName1	0x11
#define ProtocolName2	0x12
#define ProtocolName3	0x13
#define ProtocolName4	0x14
#define ProtocolName5	0x15
#define ProtocolInfo1	0x16
#define ProtocolInfo2	0x17
#define ProtocolInfo3	0x18
#define ProtocolInfo4	0x19
#define ProtocolInfo5	0x1A
#define ProtocolDlExec1	0x1B
#define ProtocolDlExec2	0x1C
#define ProtocolDlExec3	0x1D
#define ProtocolDlExec4 0x1E
#define ProtocolDlExec5	0x1F
#define ProtocolUlExec1	0x20
#define ProtocolUlExec2	0x21
#define ProtocolUlExec3	0x22
#define ProtocolUlExec4	0x23
#define ProtocolUlExec5	0x24
#define InitStr1	0x25
#define InitStr2	0x26
#define InitStr3	0x27
#define InitStr4	0x28
#define InitStr5	0x29
#define InitStr6	0x2A
#define InitStr7	0x2B
#define InitStr8	0x2C
#define InitStr9	0x2D
#define InitStr0	0x2E
#define Prefix1		0x2F
#define Prefix2		0x30
#define Prefix3		0x31
#define Prefix4		0x32
#define Prefix5		0x33
#define Prefix6		0x34
#define Suffix1		0x35
#define Suffix2		0x36
#define Suffix3		0x37
#define Suffix4		0x38
#define Suffix5		0x39
#define ExitStr		0x3A
#define Ring		0x3B
#define DialCancel	0x3C
#define AutoAnswerStr	0x3D
#define Device1		0x3E
#define Device2		0x3F
#define Device3		0x40
#define Device4		0x41
#define User1		0x42
#define User2		0x43
#define User3		0x44
#define User4		0x45
#define User5		0x46
#define User6		0x47
#define User7		0x48
#define User8		0x49
#define User9		0x4A
#define User0		0x4B
#define LockPath	0x4C
#define ConnectStr	0x4D
#define NoConnect1	0x4E
#define NoConnect2	0x4F
#define NoConnect3	0x50
#define NoConnect4	0x51
#define NoConnect5	0x52
#define Signature1	0x53
#define Signature2	0x54
#define Signature3	0x55
#define Signature4	0x56
#define Signature5	0x57
#define DeviceInit1	0x58
#define DeviceInit2	0x59
#define DeviceInit3	0x5A
#define DeviceInit4	0x5B
#define Phonebook	0x5C

#define TotalIntegers	0x5A
#define TotalStrings	0x5C

extern int Integers[TotalIntegers+1];
extern char *Strings[TotalStrings+1];
extern char Signature[5][10], DeviceInit[4][10];
extern char *TermEmu[5];

extern char *ConfigName;
int ReadConfig();
void WriteConfig();
void DumpConfig();
void SetDefault();
#endif
