/*
    error.c -- Error handling routines
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "error.h"
#include "screen.h"
#include "window.h"
#include "config.h"
#include <errno.h>
#include <string.h>
#include <unistd.h>

char Temp[50];

void WindowError(WINDOW *Window, char *ErrStr)
{
 tWindow *Win;
 int Center, Color, y, x;
 
 getyx(Window, y, x);
 
 Center = findCenter(0, COLS, strlen(ErrStr)+4);
 Color = (int)(RED << 4) + WHITE + 8;
 Win = new tWindow(Window, Center-1, LINES/2-1, Center+strlen(ErrStr)+5, LINES/2+1, Color >> 4, Color % 16);
 Win->Frame(2, Color);
 Color = (int)(RED << 4) + YELLOW + 8;
 Win->Headline("Non fatal error", Color);
 Color = (int)(RED << 4) + WHITE + 8;
 textAttr(Window, Color);
 mvwaddstr(Window, LINES/2, Center, ErrStr);
 sprintf(Temp, "#%d", errno);
 mvwaddstr(Window, LINES/2, Center+strlen(ErrStr)+strlen(Temp), Temp);
 wrefresh(Window);
 sleep(2);
 
 delete Win;
 wmove(Window, y, x);
}

void TextError(char *ErrStr)
{
 printf("Non fatal error: %s", ErrStr);
 printf(" #%d\n", errno);
 fflush(stdout);
 sleep(2);
}

void FatalWindowError(WINDOW *Window, char *ErrStr)
{
 tWindow *Win;
 int Center, Color, exitcode;
 
 Center = findCenter(0, COLS, strlen(ErrStr)+4);
 Color = (int)(RED << 4) + WHITE + 8;
 Win = new tWindow(Window, Center-1, LINES/2-1, Center+strlen(ErrStr)+5, LINES/2+1, Color >> 4, Color % 16);
 Win->Frame(2, Color);
 Color = (int)(RED << 4) + YELLOW + 8;
 Win->Headline("Fatal error", Color);
 Color = (int)(RED << 4) + WHITE + 8;
 textAttr(Window, Color);
 mvwaddstr(Window, LINES/2, Center, ErrStr);
 sprintf(Temp, "#%d", errno);
 mvwaddstr(Window, LINES/2, Center+strlen(ErrStr)+strlen(Temp), Temp);
 wrefresh(Window);
 sleep(2);
 
 delete Win;
 closeScreen();
 exitcode = 1;
 exit(exitcode);
}

void FatalTextError(char *ErrStr)
{
 printf("Fatal error: %s", ErrStr);
 printf(" #%d\n", errno);
 fflush(stdout);
 sleep(2);
 exit(255);
}

