/*
    list.c -- Linked lists in OOP
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "list.h"

/* The list constructor */
tList::tList()
{
 Total = 0;
 Base = Last = NULL;
}

/* The list destructor, frees all objects' memory */
tList::~tList()
{
 tListObj *Next, *Tmp;

 Tmp = Base;
 if (Tmp != NULL){ 
  Next = Tmp->Next;
  do
  {
   Tmp->Next = NULL;
   Tmp->Prev = NULL;
   delete Tmp;
   Tmp = Next;
   Next = Tmp->Next;
  }while (Next != NULL);
 }
}

/* Add an object at the end of the list */
void tList::Add(tListObj *Obj)
{
	if (Base == NULL) {
	 Base = Obj;
	 Obj->Next = NULL;
	 Obj->Prev = NULL;
	 Last = Base;
	}
	else
	{
	 Last->Next = Obj;
	 Obj->Prev = Last;
	 Last = Obj;
         Last->Next = NULL;
	}
	Total++;
}

/* Delets the specified object
	NOTE: This object must be in the list!
*/
void tList::Del(tListObj *Obj)
{
 tListObj *Tmp;

 if (Obj == Base) {
  Tmp = Base->Next;
  if (Tmp != NULL) Tmp->Prev = NULL;
  delete Base;
  Base = Tmp;
 }
 else if (Obj == Last) {
  Last = Last->Prev;
  Last->Next = NULL;
  delete Obj;
 }
 else
 {
  Tmp = Obj->Prev;
  Tmp->Next = Obj->Next;
  Tmp = Obj->Next;
  Tmp->Prev = Obj->Prev;
  delete Obj;
 }
 Total--;
}

/* Insert after Obj */
void tList::Insert(tListObj *Obj, tListObj *Ins)
{
 Ins->Next = Obj->Next;
 Obj->Next = Ins;
 Ins->Prev = Obj;
 if (Obj == Last)
  Last = Ins;
 else
  Ins->Next->Prev = Ins;
 Total++;
}

/* Removes the first object */
void tList::Remove()
{
 Del(Base);
}

