/*
    log.c -- Log file hnadling routines
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "log.h"
#include "config.h"
#include <stdlib.h>
#include <time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

int LogHandle;

void OpenLogfile()
{
 char c;
 
 if (Integers[OpenLog]){
   LogHandle = open(Strings[LogName], O_CREAT | O_RDWR | O_APPEND, S_IRUSR | S_IWUSR | S_IFREG);
   c = '\n';
   write(LogHandle, &c, 1);
 }
}

void CloseLog()
{
 if (Integers[OpenLog]){
  close(LogHandle);
 }
}

void Printlog(char *Str)
{
 char Temp[50];
 time_t Time;
 
 if (Integers[OpenLog]){
  time(&Time);
  strcpy(Temp, ctime(&Time));
  Temp[strlen(Temp)-1] = 0;
  strcat(Temp, "  ");
  write(LogHandle, Temp, strlen(Temp));
  write(LogHandle, Str, strlen(Str));
 }
}

void Printlogln(char *Str)
{
 char Temp[50];
 time_t Time;
 
 if (Integers[OpenLog]){
  time(&Time);
  strcpy(Temp, ctime(&Time));
  Temp[strlen(Temp)-1] = 0;
  strcat(Temp, "  ");
  write(LogHandle, Temp, strlen(Temp));
  write(LogHandle, Str, strlen(Str));
  Temp[0] = '\n';
  write(LogHandle, Temp, 1);
 }
}
