/*
    menu.h -- Header file for the menu object.
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __MENU_H_
#define __MENU_H_

#define ALIGNLEFT 0
#define ALIGNMID  1
#include <ncurses.h>

class menuItem {

  public:
  
  int X1, X2, Y;
  /* The text on the item */
  char *Text;
  /* The hotkey's position */
  int HotPos;
  menuItem *Next, *Prev;
};

class tMenu {
  int bgColor, fgColor, hotColor, hotbgColor, hotfgColor;
  int TextColor;
  int Total;
  int Align;
  WINDOW *Window;

  public:

  menuItem *Base, *Last;
  int Focus;  
  /* Initiate the menu and set the background color and foreground for 
     all items 
  */
  tMenu(WINDOW *Win, int Color, int hColor, int hiColor, int tColor, int Alignment);
  /* The destructor frees all allocated memory */
  ~tMenu();
  /* Add a menu item, in text use the tilde (~) to mark hotkey, i.e ~H~elp */
  void Add(char *text, int x1, int x2, int y);
  /* Displays the menu */
  void Show();
  /* Checks for keys, returns 0 for none chosen, otherwise the item number */
  int GetInput(int ch);
};

#endif
