/*
    phone.h -- Header file for phonebook and dialing directory routines
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef __PHONE_H_
#define __PHONE_H_

#include "list.h"
#include "screen.h"

#define EOPEN -1
#define pack __attribute__ ((packed))

class tTermPhoneRec : public tListObj {
  public:
  char Tag pack;
  char Name[31] pack;
  char Number[25] pack;
  char Device pack;
  long Baud pack;
  char Parity pack;
  char Databits pack, Stopbits pack;
  char Keyboard[9] pack;
  char Terminal pack, DialSuffix pack, DialPrefix pack;
  char Password[25] pack;
  short int Open pack, Closed pack;
  char User pack;
  char Comment1[41] pack, Comment2[41] pack;
  char LoginScript pack, Downloaddir pack;
  char Translate[9] pack, Capture[9] pack, Note[9] pack;
  char LocalEcho pack, StripHigh pack, RcvdBSdest pack;
  unsigned char Color pack;
  short int Juldate pack, Calcmin pack, Connects pack;
  long SecUsed pack, UploadKb pack, DownloadKb pack, Costs pack, LastCosts pack;
  char Protocol pack;
  char Flags pack;
};

struct tTermPhoneHeadRec {
  char Encrypted pack;
  long Seed pack;
  char Version[6] pack;
  char Comment[31] pack;
  short int Num pack;
  char CurMonth pack;
  long MonthCosts[12] pack;
  short int PhonePos pack;
  char ScrPos pack, WritePos pack;
  short int RangeStart pack, RangeStop pack;
};

struct tTelixPhoneRec {
  char Name[25] pack;
  char Number[17] pack;
  char Baud pack, Parity pack, Databits pack, Stopbits pack;
  char Script[12] pack;
  char LastCalled[6] pack;
  short int Connects;
  char Terminal pack, Protocol pack, Flags pack;
  short int Reserved pack;
  char Prefix pack;
  char Password[14] pack;
};

struct tTelixPhoneHeadRec {
  char Reserved1[6] pack;
  short int Num pack;
  char Reserved2[56] pack;
};

extern tTermPhoneRec *TermCurrentPos, *TermLastPos, *CurrentEntry;
extern int TermCurrentNumber, TermLastScrPos;
extern tTermPhoneHeadRec TermHeader;
extern tList *PhoneBook;
extern int DialerConnect, WhichBook;
extern char *CurrentPhonebook;
extern char PhonebookChanged;
int ReadTerminate(char *Filename, WINDOW *Window);
int ReadTelix(char *Filename);
int WriteTerminate(char *Filename);
int WriteTelix(char *Filename);
void ShowTerm();
void ShowTermBook(int which);
void TermPhoneKey(int ch);
void Dialer(int TopOfList);
void CommandLineDialer();
void CommandLineIndexDialer();
void SavePhonebook();
void CreateClearEntry(tTermPhoneRec *Entry);

#endif
