/*
    setup.c -- Configuration menus routines
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "setup.h"
#include "config.h"
#include "window.h"
#include "menu.h"
#include "screen.h"
#include "utils.h"
#include <stdlib.h>
#include <string.h>

void ShowColors()
{
 int i;
 
 textAttr(Screen, Integers[cInfo]);
 mvwaddch(Screen, 6, 44, DUL);
 for (i=45;i<57;i++)
  mvwaddch(Screen, 6, i, DHLINE);
 mvwaddch(Screen, 6, 57, DUR);
 textAttr(Screen, Integers[cInfoBold]);
 mvwaddstr(Screen, 7, 44, "  Hanging up  ");
 textAttr(Screen, Integers[cTerminal]);
 mvwaddstr(Screen, 8, 44, "Terminal text ");
 textAttr(Screen, Integers[cStatus]);
 mvwaddstr(Screen, 9, 44, "Ctrl-Alt-A    ");
 textAttr(Screen, Integers[cMenu]);
 mvwaddch(Screen, 10, 44, DUL);
 for (i=45;i<57;i++)
  mvwaddch(Screen, 10, i, DHLINE);
 mvwaddch(Screen, 10, 57, DUR);
 textAttr(Screen, Integers[cMenuTitle]);
 mvwaddstr(Screen, 11, 44, "Configuration ");
 textAttr(Screen, Integers[cMenuText]);
 mvwaddstr(Screen, 12, 44, "Save & Exit   ");
 textAttr(Screen, Integers[cMenuHot]);
 mvwaddch(Screen, 13, 44, 'C');
 textAttr(Screen, Integers[cMenuText]);
 mvwaddstr(Screen, 13, 45, "olors");
 textAttr(Screen, Integers[cMenuOptions]);
 mvwaddstr(Screen, 14, 44, "Yes");
 textAttr(Screen, Integers[cEdit]);
 mvwaddstr(Screen, 15, 44, "Phone number  ");
 textAttr(Screen, Integers[cMenuBar]);
 mvwaddstr(Screen, 16, 44, "Save & Exit   ");
 textAttr(Screen, Integers[cPhoneText]);
 mvwaddstr(Screen, 17, 44, "Edit  Find    ");
 textAttr(Screen, Integers[cPhoneBar]);
 mvwaddstr(Screen, 18, 44, "GoldenLine BBS");
 textAttr(Screen, Integers[cHelp]);
 mvwaddstr(Screen, 19, 44, "Exit     C-A-X");
 mvwaddstr(Screen, 20, 44, "Exit     ");
 textAttr(Screen, Integers[cHelpBold]);
 mvwaddstr(Screen, 20, 53, "C-A-X");
 textAttr(Screen, Integers[cRemote]);
 mvwaddstr(Screen, 21, 44, "JOY!          ");
 textAttr(Screen, Integers[cLocal]);
 mvwaddstr(Screen, 22, 44, "shutup        ");
}

void SetupColors()
{
 tWindow *Win;
 tMenu *Menu;
 int Key, y, x, Attr;
 
 getyx(Screen, y, x);
 Attr = Screen->_attrs;
 
 Win = new tWindow(Screen, 20, 5, 60, 23, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(2, Integers[cMenu]);
 Win->Headline(" Colors ", Integers[cMenuTitle]);

 Menu = new tMenu(Screen,Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 Menu->Add("Information", 21, 40, 6);
 Menu->Add("Information bold", 21, 40, 7);
 Menu->Add("Terminal", 21, 40, 8);
 Menu->Add("Status line", 21, 40, 9);
 Menu->Add("Menus", 21, 40, 10);
 Menu->Add("Menu title", 21, 40, 11);
 Menu->Add("Menu text", 21, 40, 12);
 Menu->Add("Menu text bold", 21, 40, 13);
 Menu->Add("Menu options", 21, 40, 14);
 Menu->Add("Edit", 21, 40, 15);
 Menu->Add("Menu bar", 21, 40, 16);
 Menu->Add("Phonebook text", 21, 40, 17);
 Menu->Add("Phone bar", 21, 40, 18);
 Menu->Add("Help", 21, 40, 19);
 Menu->Add("Help bold", 21, 40, 20);
 Menu->Add("Chat remote", 21, 40, 21);
 Menu->Add("Chat local", 21, 40, 22);
 Menu->Show();
 ShowColors();
 wrefresh(Screen);
 
 Key = 0;
 while (Key != '\e'){
   Key = getEscChar();
   Menu->GetInput(Key);
   if (Key == '\n'){
   switch(Menu->Focus){
   case 0: Integers[cInfo] = ColorChoose(Screen, Integers[cInfo]); break;
   case 1: Integers[cInfoBold] = ColorChoose(Screen, Integers[cInfoBold]); break;
   case 2: Integers[cTerminal] = ColorChoose(Screen, Integers[cTerminal]); break;
   case 3: Integers[cStatus] = ColorChoose(Screen, Integers[cStatus]); break;
   case 4: Integers[cMenu] = ColorChoose(Screen, Integers[cMenu]); break;
   case 5: Integers[cMenuTitle] = ColorChoose(Screen, Integers[cMenuTitle]); break;
   case 6: Integers[cMenuText] = ColorChoose(Screen, Integers[cMenuText]); break;
   case 7: Integers[cMenuHot] = ColorChoose(Screen, Integers[cMenuHot]); break;
   case 8: Integers[cMenuOptions] = ColorChoose(Screen, Integers[cMenuOptions]); break;
   case 9: Integers[cEdit] = ColorChoose(Screen, Integers[cEdit]); break;
   case 10: Integers[cMenuBar] = ColorChoose(Screen, Integers[cMenuBar]); break;
   case 11: Integers[cPhoneText] = ColorChoose(Screen, Integers[cPhoneText]); break;
   case 12: Integers[cPhoneBar] = ColorChoose(Screen, Integers[cPhoneBar]); break;
   case 13: Integers[cHelp] = ColorChoose(Screen, Integers[cHelp]); break;
   case 14: Integers[cHelpBold] = ColorChoose(Screen, Integers[cHelpBold]); break;
   case 15: Integers[cRemote] = ColorChoose(Screen, Integers[cRemote]); break;
   case 16: Integers[cLocal] = ColorChoose(Screen, Integers[cLocal]); break;
   default:break;
   }
   ShowColors();
   wrefresh(Screen);
   }
 }
 
 delete Menu;
 delete Win;
 wmove(Screen, y, x);
 Screen->_attrs = Attr;
 clearok(Screen, TRUE);
 wrefresh(Screen);
}

void ShowStatus()
{
 char Temp[10];
 
 textAttr(Screen, Integers[cMenuOptions]);
 switch(Integers[StatusStartOn]){
 case 0:mvwaddstr(Screen, 6, 43, "Ctrl-Alt-A ");break;
 case 1:mvwaddstr(Screen, 6, 43, "DSRDTR cd  ");break;
 case 2:mvwaddstr(Screen, 6, 43, "System name");break;
 default:break;
 }
 switch(Integers[StatusStartOff]){
 case 0:mvwaddstr(Screen, 7, 43, "Ctrl-Alt-A ");break;
 case 1:mvwaddstr(Screen, 7, 43, "DSRDTR cd  ");break;
 case 2:mvwaddstr(Screen, 7, 43, "System name");break;
 default:break;
 }
 switch(Integers[StatusEndOn]){
 case 0:mvwaddstr(Screen, 8, 43, "Time  ");break;
 case 1:mvwaddstr(Screen, 8, 43, "Online");break;
 default:break;
 }
 mvwaddstr(Screen, 9, 43, "Time");
 sprintf(Temp, "%d  ", Integers[OnlineWarn]);
 mvwaddstr(Screen, 10, 43, Temp);
 sprintf(Temp, "%d   ", Integers[ScrollBackSize]);
 mvwaddstr(Screen, 11, 43, Temp);
}

void SetupStatus()
{
 tWindow *Win;
 tMenu *Menu;
 int Key, y, x, i, Attr;
 char Temp[10];
 
 getyx(Screen, y, x);
 Attr = Screen->_attrs;
 
 Win = new tWindow(Screen, 20, 5, 60, 12, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(2, Integers[cMenu]);
 Win->Headline(" Status line ", Integers[cMenuTitle]);

 Menu = new tMenu(Screen, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 Menu->Add("Status start online", 21, 42, 6);
 Menu->Add("Status start offline", 21, 42, 7);
 Menu->Add("Status end online", 21, 42, 8);
 Menu->Add("Status end offline", 21, 42, 9);
 Menu->Add("Online warn mins.", 21, 42, 10);
 Menu->Add("Scrollback lines", 21, 42, 11);
 Menu->Show();
 ShowStatus();
 wrefresh(Screen);
 
 Key = 0;
 while (Key != '\e'){
   Key = getEscChar();
   Menu->GetInput(Key);
   if (Key == '\n'){
   switch(Menu->Focus){
   case 0: 
     Integers[StatusStartOn]++;
     if (Integers[StatusStartOn] == 3) Integers[StatusStartOn] = 0;
     break;
   case 1:
     Integers[StatusStartOff]++;
     if (Integers[StatusStartOff] == 3) Integers[StatusStartOff] = 0;
     break;
   case 2:
     Integers[StatusEndOn]++;
     if (Integers[StatusEndOn] == 2) Integers[StatusEndOn] = 0;
     break;
   case 4:
     sprintf(Temp, "%d", Integers[OnlineWarn]);
     if (getstring(Screen, 10, 43, Temp, NumberEdit, "\e\n", 3, -1, Temp) == '\n')
      Integers[OnlineWarn] = atoi(Temp);
     break;
   case 5:
     sprintf(Temp, "%d", Integers[ScrollBackSize]);
     if (getstring(Screen, 11, 43, Temp, NumberEdit, "\e\n", 4, -1, Temp) == '\n'){
      i = atoi(Temp);
      if (i > LINES-1) Integers[ScrollBackSize] = i;
     }
     break;
   default:break;
   }
   ShowStatus();
   wrefresh(Screen);
   }
 }
 
 delete Menu;
 delete Win;
 wmove(Screen, y, x);
 Screen->_attrs = Attr;
 clearok(Screen, TRUE);
 wrefresh(Screen);
}

void ShowToggles()
{
 int i;
 char Yes[4];
 
 textAttr(Screen, Integers[cMenuOptions]);
 strcpy(Yes, "Yes");
 
 for (i=2;i<22;i++)
  mvwaddstr(Screen, i, 52, "No ");
  
 if (Integers[GlobalLocalEcho]) mvwaddstr(Screen, 2, 52, Yes);
 if (Integers[GlobalStripHigh]) mvwaddstr(Screen, 3, 52, Yes);
 if (Integers[BSdest]) mvwaddstr(Screen, 4, 52, Yes);
 if (Integers[AskDevice]) mvwaddstr(Screen, 5, 52, Yes);
 if (Integers[StartInPhone]) mvwaddstr(Screen, 6, 52, Yes);
 if (Integers[StartInTop]) mvwaddstr(Screen, 7, 52, Yes);
 if (Integers[AskCurrentPhone]) mvwaddstr(Screen, 8, 52, Yes);
 if (Integers[PhoneBookOnDrop]) mvwaddstr(Screen, 9, 52, Yes);
 if (Integers[OpenLog]) mvwaddstr(Screen, 10, 52, Yes);
 if (Integers[AutoOpenCapture]) mvwaddstr(Screen, 11, 52, Yes);
 if (Integers[AppendCapture]) mvwaddstr(Screen, 12, 52, Yes);
 if (Integers[SaveControl]) mvwaddstr(Screen, 13, 52, Yes);
 if (Integers[CaptureKeys]) mvwaddstr(Screen, 14, 52, Yes);
 if (Integers[HidePwds]) mvwaddstr(Screen, 15, 52, Yes);
 if (Integers[AskOnHang]) mvwaddstr(Screen, 16, 52, Yes);
 if (Integers[AskOnExit]) mvwaddstr(Screen, 17, 52, Yes);
 if (Integers[TagAdvance]) mvwaddstr(Screen, 18, 52, Yes);
 if (Integers[AutoAnswer]) mvwaddstr(Screen, 19, 52, Yes);
 if (Integers[ForceInit]) mvwaddstr(Screen, 20, 52, Yes);
 if (Integers[EscType]) mvwaddstr(Screen, 21, 52, Yes);
}

void SetupToggles()
{
 tWindow *Win;
 tMenu *Menu;
 int Key, y, x, Attr;
 
 getyx(Screen, y, x);
 Attr = Screen->_attrs;
 
 Win = new tWindow(Screen, 20, 1, 60, 22, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(2, Integers[cMenu]);
 Win->Headline(" Toggles ", Integers[cMenuTitle]);

 Menu = new tMenu(Screen, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 Menu->Add("Local echo", 21, 50, 2);
 Menu->Add("Strip high", 21, 50, 3);
 Menu->Add("Destructive backspace", 21, 50, 4);
 Menu->Add("Ask device on statrup", 21, 50, 5);
 Menu->Add("Start in phonebook", 21, 50, 6);
 Menu->Add("Start in top of phonebook", 21, 50, 7);
 Menu->Add("Ask default phonebook", 21, 50, 8);
 Menu->Add("Phonebook after hangup", 21, 50, 9);
 Menu->Add("Make a log", 21, 50, 10);
 Menu->Add("Automaticly open capture", 21, 50, 11);
 Menu->Add("Append capture", 21, 50, 12);
 Menu->Add("Control codes in capture", 21, 50, 13);
 Menu->Add("Keystrokes in capture", 21, 50, 14);
 Menu->Add("Hide passwords", 21, 50, 15);
 Menu->Add("Ask before hanging up", 21,50, 16);
 Menu->Add("Ask before exiting", 21, 50, 17);
 Menu->Add("Advance bar on tag", 21, 50, 18);
 Menu->Add("Answer incoming calls", 21, 50, 19);
 Menu->Add("Force init-strings", 21, 50, 20);
 Menu->Add("Use Ctrl-Alt combo", 21, 50, 21);
 Menu->Show();
 ShowToggles();
 wrefresh(Screen);
 
 Key = 0;
 while (Key != '\e'){
   Key = getEscChar();
   Menu->GetInput(Key);
   if (Key == '\n'){
   switch(Menu->Focus){
   case 0:Integers[GlobalLocalEcho] ^= 1; break;
   case 1:Integers[GlobalStripHigh] ^= 1; break;
   case 2:Integers[BSdest] ^= 1; break;
   case 3:Integers[AskDevice] ^= 1; break;
   case 4:Integers[StartInPhone] ^= 1; break;
   case 5:Integers[StartInTop] ^= 1; break;
   case 6:Integers[AskCurrentPhone] ^= 1; break;
   case 7:Integers[PhoneBookOnDrop] ^= 1; break;
   case 8:Integers[OpenLog] ^= 1; break;
   case 9:Integers[AutoOpenCapture] ^= 1; break;
   case 10:Integers[AppendCapture] ^= 1; break;
   case 11:Integers[SaveControl] ^= 1; break;
   case 12:Integers[CaptureKeys] ^= 1; break;
   case 13:Integers[HidePwds] ^= 1; break;
   case 14:Integers[AskOnHang] ^= 1; break;
   case 15:Integers[AskOnExit] ^= 1; break;
   case 16:Integers[TagAdvance] ^= 1; break;
   case 17:Integers[AutoAnswer] ^= 1; break;
   case 18:Integers[ForceInit] ^= 1; break;
   case 19:Integers[EscType] ^= 1; break;
   default:break;
   }
   ShowToggles();
   wrefresh(Screen);
   }
 }
 
 delete Menu;
 delete Win;
 wmove(Screen, y, x);
 Screen->_attrs = Attr;
 clearok(Screen, TRUE);
 wrefresh(Screen);
}

void ShowModem()
{
 char Temp[20];
 
 textAttr(Screen, Integers[cMenuOptions]);
 mvwaddstr(Screen, 10, 40, Strings[ExitStr]);
 mvwaddstr(Screen, 11, 40, Strings[ConnectStr]);
 mvwaddstr(Screen, 13, 40, Strings[Ring]);
 mvwaddstr(Screen, 14, 40, Strings[DialCancel]);
 mvwaddstr(Screen, 15, 40, Strings[AutoAnswerStr]);
 sprintf(Temp, "%d", Integers[DialTime]);
 mvwaddstr(Screen, 17, 40, Temp);
 sprintf(Temp, "%d", Integers[DialDelay]);
 mvwaddstr(Screen, 18, 40, Temp);
 sprintf(Temp, "%d", Integers[LoopDelay]);
 mvwaddstr(Screen, 19, 40, Temp);
}

void SetupModem()
{
 tWindow *Win;
 tMenu *Menu;
 int Key, y, x, i, Attr;
 char Temp[21];
 
 getyx(Screen, y, x);
 Attr = Screen->_attrs;
 
 Win = new tWindow(Screen, 20, 5, 60, 20, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(2, Integers[cMenu]);
 Win->Headline(" Modems ", Integers[cMenuTitle]);

 Menu = new tMenu(Screen, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 Menu->Add("Devices", 21, 38, 6);
 Menu->Add("Init strings", 21, 38, 7);
 Menu->Add("Prefixes", 21, 38, 8);
 Menu->Add("Suffixes", 21, 38, 9);
 Menu->Add("Exit string", 21, 38, 10);
 Menu->Add("Connect string", 21, 38, 11);
 Menu->Add("No connect", 21, 38, 12);
 Menu->Add("Ring", 21, 38, 13);
 Menu->Add("Dial cancel", 21, 38, 14);
 Menu->Add("Auto answer", 21, 38, 15);
 Menu->Add("Device inits", 21, 38, 16);
 Menu->Add("Dial time", 21, 38, 17);
 Menu->Add("Dial delay", 21, 38, 18);
 Menu->Add("Loop delay", 21, 38, 19);
 Menu->Show();
 ShowModem();
 wrefresh(Screen);
 
 Key = 0;
 while (Key != '\e'){
   Key = getEscChar();
   Menu->GetInput(Key);
   if (Key == '\n'){
   textAttr(Screen, Integers[cEdit]);
   clearok(Screen, TRUE);
   switch(Menu->Focus){
   case 0:
     i = ChooseDevice(Screen, Integers[DefaultDevice], 1);
     if (i > 0) Integers[DefaultDevice] = i;
     break;
   case 1:ChooseInit(Screen, 0); break;
   case 2:ChoosePrefix(Screen, 0); break;
   case 3:ChooseSuffix(Screen, 0); break;
   case 4:
     if (getstring(Screen, 10, 40, Strings[ExitStr], ValidEdit, "\e\n", 20, -1, Temp) == '\n')
      Strings[ExitStr] = (char *)realloc(Strings[ExitStr], strlen(Temp)+1);
      strcpy(Strings[ExitStr], Temp);
     break;
   case 5:
     if (getstring(Screen, 11, 40, Strings[ConnectStr], ValidEdit, "\e\n", 20, -1, Temp) == '\n')
      Strings[ConnectStr] = (char *)realloc(Strings[ConnectStr], strlen(Temp)+1);
      strcpy(Strings[ConnectStr], Temp);
     break;
   case 6:ChooseNoConnect(Screen, 0); break;
   case 7:
     if (getstring(Screen, 13, 40, Strings[Ring], ValidEdit, "\e\n", 20, -1, Temp) == '\n')
      Strings[Ring] = (char *)realloc(Strings[Ring], strlen(Temp)+1);
      strcpy(Strings[Ring], Temp);
     break;
   case 8:
     if (getstring(Screen, 14, 40, Strings[DialCancel], ValidEdit, "\e\n", 20, -1, Temp) == '\n')
      Strings[DialCancel] = (char *)realloc(Strings[DialCancel], strlen(Temp)+1);
      strcpy(Strings[DialCancel], Temp);
     break;
   case 9:
     if (getstring(Screen, 15, 40, Strings[AutoAnswerStr], ValidEdit, "\e\n", 20, -1, Temp) == '\n')
      Strings[AutoAnswerStr] = (char *)realloc(Strings[AutoAnswerStr], strlen(Temp)+1);
      strcpy(Strings[AutoAnswerStr], Temp);
     break;
   case 10:ChooseDeviceInit(Screen, 0); break;
   case 11:
     sprintf(Temp, "%d", Integers[DialTime]);
     if (getstring(Screen, 17, 40, Temp, ValidEdit, "\e\n", 20, -1, Temp) == '\n')
       Integers[DialTime] = atoi(Temp);
     break;
   case 12:
     sprintf(Temp, "%d", Integers[DialDelay]);
     if (getstring(Screen, 18, 40, Temp, ValidEdit, "\e\n", 20, -1, Temp) == '\n')
       Integers[DialDelay] = atoi(Temp);
     break;
   case 13:
     sprintf(Temp, "%d", Integers[LoopDelay]);
     if (getstring(Screen, 19, 40, Temp, ValidEdit, "\e\n", 20, -1, Temp) == '\n')
       Integers[LoopDelay] = atoi(Temp);
     break;
   default:break;
   }
   ShowModem();
   wrefresh(Screen);
   }
 }
 
 delete Menu;
 delete Win;
 wmove(Screen, y, x);
 Screen->_attrs = Attr;
 clearok(Screen, TRUE);
 wrefresh(Screen);
}

void ShowPath()
{
 int i;
 char Temp[33], TempString[250];
 
 for (i=0;i<32;i++)
  Temp[i] = ' ';
 Temp[32] = 0;

 textAttr(Screen, Integers[cMenuOptions]);
 mvwaddstr(Screen, 6, 38, Temp);
 strcpy(TempString, Strings[LogName]);
 TempString[32] = 0; 
 mvwaddstr(Screen, 6, 38, TempString);
 mvwaddstr(Screen, 7, 38, Temp);
 strcpy(TempString, Strings[DownloadPath]);
 TempString[32] = 0; 
 mvwaddstr(Screen, 7, 38, TempString);
 mvwaddstr(Screen, 8, 38, Temp);
 strcpy(TempString, Strings[UploadPath]);
 TempString[32] = 0; 
 mvwaddstr(Screen, 8, 38, TempString);
 mvwaddstr(Screen, 9, 38, Temp);
 strcpy(TempString, Strings[CapturePath]);
 TempString[32] = 0; 
 mvwaddstr(Screen, 9, 38, TempString);
 mvwaddstr(Screen, 10, 38, Temp);
 strcpy(TempString, Strings[PhonePath]);
 TempString[32] = 0; 
 mvwaddstr(Screen, 10, 38, TempString);
 mvwaddstr(Screen, 11, 38, Temp);
 strcpy(TempString, Strings[LockPath]);
 TempString[32] = 0; 
 mvwaddstr(Screen, 11, 38, TempString);
}

void SetupFile()
{
 tWindow *Win;
 tMenu *Menu;
 int Key, y, x, Attr;
 char Temp[21];
 
 getyx(Screen, y, x);
 Attr = Screen->_attrs;
 
 Win = new tWindow(Screen, 20, 5, 70, 12, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(2, Integers[cMenu]);
 Win->Headline(" Files and Paths ", Integers[cMenuTitle]);

 Menu = new tMenu(Screen, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 Menu->Add("Log file name", 21, 36, 6);
 Menu->Add("Download path", 21, 36, 7);
 Menu->Add("Upload path", 21, 36, 8);
 Menu->Add("Capture path", 21, 36, 9);
 Menu->Add("Phone path", 21, 36, 10);
 Menu->Add("Lock path", 21, 36, 11);
 Menu->Show();
 ShowPath();
 wrefresh(Screen);
 
 Key = 0;
 while (Key != '\e'){
   Key = getEscChar();
   Menu->GetInput(Key);
   if (Key == '\n'){
   textAttr(Screen, Integers[cEdit]);
   clearok(Screen, TRUE);
   switch(Menu->Focus){
   case 0:
     if (getstring(Screen, 6, 38, Strings[LogName], FileEdit, "\e\n", 32, -1, Temp) == '\n')
      Strings[LogName] = (char *)realloc(Strings[LogName], strlen(Temp)+1);
      strcpy(Strings[LogName], Temp);
     break;
   case 1:
     if (getstring(Screen, 7, 38, Strings[DownloadPath], FileEdit, "\e\n", 32, -1, Temp) == '\n')
      Strings[DownloadPath] = (char *)realloc(Strings[DownloadPath], strlen(Temp)+1);
      strcpy(Strings[DownloadPath], Temp);
     break;
   case 2:
     if (getstring(Screen, 8, 38, Strings[UploadPath], FileEdit, "\e\n", 32, -1, Temp) == '\n')
      Strings[UploadPath] = (char *)realloc(Strings[UploadPath], strlen(Temp)+1);
      strcpy(Strings[UploadPath], Temp);
     break;
   case 3:
     if (getstring(Screen, 9, 38, Strings[CapturePath], FileEdit, "\e\n", 32, -1, Temp) == '\n')
      Strings[CapturePath] = (char *)realloc(Strings[CapturePath], strlen(Temp)+1);
      strcpy(Strings[CapturePath], Temp);
     break;
   case 4:
     if (getstring(Screen, 10, 38, Strings[PhonePath], FileEdit, "\e\n", 32, -1, Temp) == '\n')
      Strings[PhonePath] = (char *)realloc(Strings[PhonePath], strlen(Temp)+1);
      strcpy(Strings[PhonePath], Temp);
     break;
   case 5:
     if (getstring(Screen, 11, 38, Strings[LockPath], FileEdit, "\e\n", 32, -1, Temp) == '\n')
      Strings[LockPath] = (char *)realloc(Strings[LockPath], strlen(Temp)+1);
      strcpy(Strings[LockPath], Temp);
     break;
   default:break;
   }
   ShowPath();
   wrefresh(Screen);
   }
 }
 
 delete Menu;
 delete Win;
 wmove(Screen, y, x);
 Screen->_attrs = Attr;
 clearok(Screen, TRUE);
 wrefresh(Screen);
}

void ShowProtocol(int Which)
{
 int i;
 char Temp[33], Yes[4], TempString[250];
 
 strcpy(Yes, "Yes");
 for (i=0;i<32;i++)
  Temp[i] = ' ';
 Temp[32] = 0;
 
 textAttr(Screen, Integers[cMenuOptions]);
 mvwaddstr(Screen, 6, 38, Temp);
 strcpy(TempString, Strings[ProtocolName1+Which]);
 TempString[32] = 0;
 mvwaddstr(Screen, 6, 38, TempString);
 mvwaddstr(Screen, 7, 38, Temp);
 strcpy(TempString, Strings[ProtocolInfo1+Which]);
 TempString[32] = 0;
 mvwaddstr(Screen, 7, 38, TempString);
 mvwaddstr(Screen, 8, 38, Temp);
 strcpy(TempString, Strings[ProtocolDlExec1+Which]);
 TempString[32] = 0;
 mvwaddstr(Screen, 8, 38, TempString);
 mvwaddstr(Screen, 9, 38, Temp);
 strcpy(TempString, Strings[ProtocolUlExec1+Which]);
 TempString[32] = 0;
 mvwaddstr(Screen, 9, 38, TempString);
 for (i=10;i<13;i++)
  mvwaddstr(Screen, i, 38, "No ");
 if (Integers[ProtocolAsk1+Which]) mvwaddstr(Screen, 10, 38, Yes);
 if (Integers[ChangeDl1+Which]) mvwaddstr(Screen, 11, 38, Yes);
 if (Integers[ChangeUl1+Which]) mvwaddstr(Screen, 12, 38, Yes);
 for (i=0;i<10;i++){
  sprintf(Temp, "%02X", Signature[Which][i+2]);
  mvwaddstr(Screen, 13, i*2+38, Temp);
 }
}

void SetupProtocol()
{
 tWindow *Win;
 tMenu *Menu;
 int Key, y, x, i, Attr, WhichProtocol;
 char Temp[50], TempStr[50];
 
 getyx(Screen, y, x);
 Attr = Screen->_attrs;
 
 Win = new tWindow(Screen, 20, 5, 70, 14, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(2, Integers[cMenu]);
 Win->Headline(" Protocols ", Integers[cMenuTitle]);

 Menu = new tMenu(Screen, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 Menu->Add("Protocol name", 21, 37, 6);
 Menu->Add("Protocol info", 21, 37, 7);
 Menu->Add("Donwload exec", 21, 37, 8);
 Menu->Add("Upload exec", 21, 37, 9);
 Menu->Add("Ask for name", 21, 37, 10);
 Menu->Add("Change to ul dir", 21, 37, 11);
 Menu->Add("Change to dl dir", 21, 37, 12);
 Menu->Add("Signature", 21, 37, 13);
 Menu->Show();
 ShowProtocol(0);
 WhichProtocol = 0;
 wrefresh(Screen);
 
 Key = 0;
 while (Key != '\e'){
   Key = getEscChar();
   Menu->GetInput(Key);
   if (Key > 48 && Key < 54){ 
     WhichProtocol = Key - 49;
     ShowProtocol(WhichProtocol);
     clearok(Screen, TRUE);
     wrefresh(Screen);
   }
   if (Key == '\n'){
   textAttr(Screen, Integers[cEdit]);
   clearok(Screen, TRUE);
   switch(Menu->Focus){
   case 0:
     if (getstring(Screen, 6, 38, Strings[ProtocolName1+WhichProtocol], ValidEdit, "\e\n", 32, -1, Temp) == '\n')
      Strings[ProtocolName1+WhichProtocol] = (char *)realloc(Strings[ProtocolName1+WhichProtocol], strlen(Temp)+1);
      strcpy(Strings[ProtocolName1+WhichProtocol], Temp);
     break;
   case 1:
     if (getstring(Screen, 7, 38, Strings[ProtocolInfo1+WhichProtocol], ValidEdit, "\e\n", 32, -1, Temp) == '\n')
      Strings[ProtocolInfo1+WhichProtocol] = (char *)realloc(Strings[ProtocolInfo1+WhichProtocol], strlen(Temp)+1);
      strcpy(Strings[ProtocolInfo1+WhichProtocol], Temp);
     break;
   case 2:
     if (getstring(Screen, 8, 38, Strings[ProtocolDlExec1+WhichProtocol], ValidEdit, "\e\n", 32, -1, Temp) == '\n')
      Strings[ProtocolDlExec1+WhichProtocol] = (char *)realloc(Strings[ProtocolDlExec1+WhichProtocol], strlen(Temp)+1);
      strcpy(Strings[ProtocolDlExec1+WhichProtocol], Temp);
     break;
   case 3:
     if (getstring(Screen, 9, 38, Strings[ProtocolUlExec1+WhichProtocol], ValidEdit, "\e\n", 32, -1, Temp) == '\n')
      Strings[ProtocolUlExec1+WhichProtocol] = (char *)realloc(Strings[ProtocolUlExec1+WhichProtocol],strlen(Temp)+1);
      strcpy(Strings[ProtocolUlExec1+WhichProtocol], Temp);
     break;
   case 4: Integers[ProtocolAsk1+WhichProtocol] ^= 1; break;
   case 5: Integers[ChangeDl1+WhichProtocol] ^= 1; break;
   case 6: Integers[ChangeUl1+WhichProtocol] ^= 1; break;
   case 7:
     TempStr[0] = 0;
     for (i=0;i<10;i++){
      sprintf(Temp, "%02X", Signature[WhichProtocol][i+2]);
      strcat(TempStr, Temp);
     }
     if (getstring(Screen, 13, 38, TempStr, HexEdit, "\e\n", 20, -1, Temp) == '\n'){
      for (i=0;i<(int)strlen(Temp)/2;i++){
       strncpy(TempStr, Temp+i*2, 2);
       TempStr[2]=0;
       Signature[WhichProtocol][i+2] = strtol(TempStr, NULL, 16);
      }
     }
     break;
   default:break;
   }
   ShowProtocol(WhichProtocol);
   wrefresh(Screen);
   }
 }
 
 delete Menu;
 delete Win;
 wmove(Screen, y, x);
 Screen->_attrs = Attr;
 clearok(Screen, TRUE);
 wrefresh(Screen);
}

void Setup()
{
 tWindow *Win;
 tMenu *Menu;
 int Key, y, x, Attr, Quit;
 
 getyx(Screen, y, x);
 Attr = Screen->_attrs;
 nl();
 
 Win = new tWindow(Screen, 30, 5, 50, 15, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(2, Integers[cMenu]);
 Win->Headline(" Configuration ", Integers[cMenuTitle]);

 Menu = new tMenu(Screen, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 Menu->Add("~C~olors", 31, 50, 6);
 Menu->Add("Stat~u~s", 31, 50, 7);
 Menu->Add("~T~oggles", 31, 50, 8);
 Menu->Add("~M~odem", 31, 50, 9);
 Menu->Add("~F~iles & Paths", 31, 50, 10);
 Menu->Add("~P~rotocols", 31, 50, 11);
 Menu->Add("M~a~cros", 31, 50, 12);
 Menu->Add("~S~ave & exit", 31, 50, 13);
 Menu->Add("~E~xit", 31, 50, 14);
 Menu->Show();
 wrefresh(Screen);
 
 Key = 0;
 Quit = 0;
 while (Key != '\e' && !Quit){
   Key = getEscChar();
   Menu->GetInput(Key);
   if (Key == '\n'){
    switch(Menu->Focus){
    case 0:
      SetupColors();
      break;
    case 1:
      SetupStatus();
      break;
    case 2:
      SetupToggles();
      break;
    case 3:
      SetupModem();
      break;
    case 4:
      SetupFile();
      break;
    case 5:
      SetupProtocol();
      break;
    case 6:
      ChooseMacro(Screen, 0);
      break;
    case 7:
      if (ChooseYesno(Screen, " Write configuration to disk? ")) 
       if (Integers[DumpVar]) DumpConfig(); 
        else WriteConfig();
      Quit = 1;
      break;
    case 8:
      Quit = 1;
      break;
    default:break;
    }
    wrefresh(Screen);
   }
 }
 
 delete Menu;
 delete Win;
 
 wmove(Screen, y, x);
 Screen->_attrs = Attr;
 nonl();
}

