/*
    utils.c -- Utility routines
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "screen.h"
#include "utils.h"
#include "config.h"
#include "window.h"
#include "menu.h"
#include "phone.h"
#include "error.h"
#include "log.h"
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#include <time.h>
#include <fcntl.h>

int Year, Month, Day;

void OpenCaptureFile(WINDOW *Window, char *CaptureName)
{
 char Temp[40], TempStr[255];
 tWindow *Win;
 int Center, Y, X;
 int mode, i;
 time_t t;
 tm *Time;

 TempStr[0] = 0;
 strcpy(TempStr, Strings[CapturePath]);
 strcat(TempStr, "/");
 strcat(TempStr, CaptureName);
 if (strlen(CaptureName)>0){
  mode = O_RDWR | O_CREAT;
  if (Integers[AppendCapture]) mode |= O_APPEND;
  else mode |= O_TRUNC;
  if ((CaptureHandle = open(TempStr, mode, S_IFREG | S_IRUSR | S_IWUSR)) > 0){
   CaptureOn = 1;
   if (Integers[AppendCapture]){
    time(&t);
    Time = localtime(&t);
    for (i = 0; i < 80; i++)
     TempStr[i] = '*';
    write(CaptureHandle, "\n", 1);
    write(CaptureHandle, &TempStr, 80);
    strcpy(Temp, ctime(&t));
    write(CaptureHandle, &Temp, strlen(Temp));
    write(CaptureHandle, &TempStr, 80);
   }
   strcpy(TempStr, "Capture open:");
   strcat(TempStr, CaptureName);
   Printlogln(TempStr);
  }
  else WindowError(Window, "Unable to open file");
 }
}

void DisplayMessage(WINDOW *Window, char *Text, int sleeptime)
{
 tWindow *Win;
 int Center, Y, X, Attr;
 char Temp[10];
 
 Attr = Window->_attrs;
 getyx(Window, Y, X); 
 Center = findCenter(0, COLS, strlen(Text));
 Win = new tWindow(Window, Center-3, LINES/2-2, Center+strlen(Text)+1, LINES/2+2, Integers[cInfo] >> 4, 
           Integers[cInfo] % 16);
 Win->Frame(2, Integers[cInfo]);
 textAttr(Window, Integers[cInfoBold]);
 mvwaddstr(Window, LINES/2, Center, Text);
 wrefresh(Window);
 sleep(sleeptime);

 delete Win;
 wmove(Window, Y, X);
 Window->_attrs = Attr;
}

char *nocasestrstr(char *Haystack, char *Needle)
{
 int i, j, len1 = strlen(Haystack), len2 = strlen(Needle);
 
 for (i = 0; i < len1 && j != len2; i++)
 {
  j = 0;
  while (tolower(*(Haystack+j+i)) == tolower(*(Needle+j)) && *(Haystack+j+i) != '\0' && *(Needle+j) != '\0') j++;
 }
 if (j == len2) return(Haystack+i);
 else return NULL;
}

int ValidName(char *Str, char *Putin)
{
 int i,j;
 char NumOfDots, Space, DotPos;
 char *Ptr;
 
 NumOfDots = 0;
 Space = 0;
 DotPos = 0;
 
 Ptr = Str;
 i = 0;
 j = 0;
 while (i<12 && NumOfDots < 2 && !Space && *Ptr != 0){
 if (*Ptr == '.'){ 
  NumOfDots++; 
  DotPos = Ptr - Str; 
  i = 8;
  *(Putin+j) = '.';
  j++;
 }
 if (isspace(*Ptr)){ 
  Space++;
  i--;
 }
 if (isalnum(*Ptr)) {
  *(Putin+j) = *Ptr;
  j++;
 }
 i++;
 Ptr++;
 }
 *(Putin+j) = 0;
 if (i == 0 || NumOfDots > 1 || (i > 8 && NumOfDots == 0) || DotPos > 8 || !isspace(*(Str+j)))
  return 0;
 return 1;
}

/*void FromJulian(int Date)
{
 long Temp;
 int Days[2][12] = {0,31,59,90,120,151,181,212,243,273,304,334,0,31,60,91,121,152,182,213,244,274,305,335};
 int counter, Leap;
 
 Year = 100*Date/36525;
 Temp = Year*36525l;
 Date -= Temp/100;
 if (Temp % 100 == 0){
  Date++; Leap = 1;
 }
 else Leap = 0;
 for (Month=counter=0;counter<12;counter++)
  if (Days[Leap][counter]<Date)
    Month = counter+1;
 Day = Date - Days[Leap][Month];
}*/

void ReplaceM(char *s)
{
 char *ptr;
 char Replaced;
 
 Replaced = 1;
 while (Replaced){
  Replaced = 0;
  if ((ptr=strstr(s, "^M")) != NULL){
   *ptr = '\r';
   strcpy(ptr+1, ptr+2);
   Replaced = 1;
  }
  if ((ptr=strstr(s, "^J")) != NULL){
   *ptr = '\n';
   strcpy(ptr+1, ptr+2);
   Replaced = 1;
  }
 }
}

void MacroParser(char *s, char *Username, char *Pwd)
{
 char *ptr;
 char Replaced, Temp[256], Pass[40];
 
 Replaced = 1;
 CharToPas(Pwd, Pass);
 while (Replaced){
  Replaced = 0;
  if ((ptr=strstr(s, "^")) != NULL){
   *ptr = *(ptr+1)-64;
   strcpy(ptr+1, ptr+3);
   Replaced = 1;
  }
  if ((ptr=strstr(s, "!S")) != NULL){
   strncpy(Temp, s, ptr-s);
   Temp[ptr-s]=0;
   strcat(Temp, Username);
   strcat(Temp, ptr+2);
   strcpy(s, Temp);
   Replaced = 1;
  }
  if ((ptr=strstr(s, "!P")) != NULL){
   strncpy(Temp, s, ptr-s);
   Temp[ptr-s]=0;
   strcat(Temp, Pass);
   strcat(Temp, ptr+2);
   strcpy(s, Temp);
   Replaced = 1;
  }
 }
}

void ProtocolParser(char *s, char *Dl, char *Device, int Baud, char *Filename)
{
 char *ptr;
 char Replaced, Temp[256], BaudStr[10];
 
 Replaced = 1;
 sprintf(BaudStr,"%d",Baud);
 while (Replaced){
  Replaced = 0;
  if ((ptr=strstr(s, "!P")) != NULL){
   strncpy(Temp, s, ptr-s);
   Temp[ptr-s]=0;
   strcat(Temp, Dl);
   strcat(Temp, ptr+2);
   strcpy(s, Temp);
   Replaced = 1;
  }
  if ((ptr=strstr(s, "!D")) != NULL){
   strncpy(Temp, s, ptr-s);
   Temp[ptr-s]=0;
   strcat(Temp, Device);
   strcat(Temp, ptr+2);
   strcpy(s, Temp);
   Replaced = 1;
  }
  if ((ptr=strstr(s, "!B")) != NULL){
   strncpy(Temp, s, ptr-s);
   Temp[ptr-s]=0;
   strcat(Temp, BaudStr);
   strcat(Temp, ptr+2);
   strcpy(s, Temp);
   Replaced = 1;
  }
  if ((ptr=strstr(s, "!F")) != NULL){
   strncpy(Temp, s, ptr-s);
   Temp[ptr-s]=0;
   strcat(Temp, Filename);
   strcat(Temp, ptr+2);
   strcpy(s, Temp);
   Replaced = 1;
  }
 }
}

void Julian(int Jul)
{
 long Temp, XYear;
 short int YYear, YMonth, YDay;
 
 Temp = (((Jul-1721119) << 2) - 1);
 XYear = (Temp % 146097) | 3;
 Jul = Temp / 146097;
 YYear = XYear / 1461;
 Temp = ((((XYear % 1461) + 4) >> 2) * 5) - 3;
 YMonth =  Temp / 153;
 if (YMonth >= 10) {
 YYear++;
 YMonth -= 12;
 }
 YMonth = YMonth + 3;
 YDay = Temp % 153;
 YDay = (YDay + 5) / 5;
 Year = YYear + (Jul * 100);
 Month = YMonth;
 Day = YDay;
}

void PasToChar(char *Pas, char *Char)
{
 char s[256];
 
 if (*Pas+1 == 0) *Char = 0;
 else{
  strncpy(s, Pas, *Pas+1);
  s[s[0]+1]=0;
  strcpy(Char, &s[1]);
 }
}

void CharToPas(char *Pas, char *Char)
{

 strncpy(Pas+1, Char, strlen(Char));
 *Pas = strlen(Char);
}

int ColorChoose(WINDOW *Window, int Color)
{
 int Key, Refresh, LastColor, Blink;
 tWindow *Win;
 int i, j, x, y, savecolor;

 Win = new tWindow(Window, 50, 5, 72, 21, BLACK, WHITE);
 
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Color selection", Integers[cMenuTitle]);
 textColor(Window, WHITE);
 textBkgd(Window, BLACK);
 mvwaddstr(Window, 19, findCenter(50,72,7), "B-Blink");
 savecolor = Color;
 Blink = 0;
 if (Color > 128) {
 Color-=128;
 Blink = ~Blink;
 }
 
 for (y=9,i=0;y<17;y++,i++)
  for (x=53,j=0;x<69;x++,j++)
  {
   textAttr(Window, (i << 4) + j + (Blink & 128));
   mvwaddch(Window, y, x, 254);
  }
  
 wrefresh(Window);
 Key = 0;
 Refresh = 1;
 LastColor = Color;
 while (Key != '\e' && Key !='\n'){
   textAttr(Window, LastColor + (Blink & 128));
   mvwaddch(Window, 9+(LastColor >> 4), 53+(LastColor % 16), 254);
   textColor(Window, WHITE);
   textBkgd(Window, BLACK);
   mvwaddch(Window, 9+(LastColor >> 4), 52, ' ');
   mvwaddch(Window, 9+(LastColor >> 4), 69, ' ');
   mvwaddch(Window, 8, 53+(LastColor % 16), ' ');
   mvwaddch(Window, 17, 53+(LastColor % 16), ' ');
  
   wrefresh(Window); 
   textAttr(Window, Color + (Blink & 128));
   mvwaddstr(Window, 7, findCenter(50,72,12), "Sample color");
   wrefresh(Window);
   mvwaddch(Window, 9+(Color >> 4), 53+(Color % 16), '0');
   textColor(Window, WHITE);
   textBkgd(Window, BLACK);
   mvwaddch(Window, 9+(Color >> 4), 52, SHLINE);
   mvwaddch(Window, 9+(Color >> 4), 69, SHLINE);
   wrefresh(Window);
   mvwaddch(Window, 8, 53+(Color % 16), '|');
   mvwaddch(Window, 17, 53+(Color % 16), '|');
   LastColor = Color;
   wrefresh(Window);
   Key = getEscChar();
   switch(Key){
   case KEY_DOWN:
     if (Color >> 4 < 7){ 
       Color+=16;
       Refresh = 1;
     }
     break;
   case KEY_UP:
     if (Color >> 4 > 0){
       Color-=16;
       Refresh = 1;
     }
     break;
   case KEY_LEFT:
     if (Color % 16 > 0){
      Color--;
      Refresh = 1;
     }
     break;
   case KEY_RIGHT:
     if (Color % 16 < 15){
      Color++;
      Refresh = 1;
     }
     break;
   case 'b':
   case 'B':
     Blink = ~Blink;
     for (y=9,i=0;y<17;y++,i++)
      for (x=53,j=0;x<69;x++,j++)
     {
      textAttr(Window, (i << 4) + j + (Blink & 128));
      mvwaddch(Window, y, x, 254);
      wrefresh(Window);
     }
     break;
   default: Refresh = 0; break;
 }
 }
  
 delete Win;
 clearok(Window, TRUE);
 if (Key == '\e') return (savecolor);
 else
  return (Color+(Blink & 128));
}

long int ChooseBaud(WINDOW *Window, long int Baud)
{
 int Key, Attr, x, y;
 tWindow *Win;
 tMenu *Menu;
 
 Attr = Window->_attrs;
 getyx(Window, y, x);
 
 Win = new tWindow(Window, 56,2,70,14, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Choose baud", Integers[cMenuTitle]);
 
 Menu = new tMenu(Window, Integers[cMenuText], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText],             ALIGNLEFT);
 Menu->Add("      300",57,70,3);
 Menu->Add("      600",57,70,4);
 Menu->Add("     1200",57,70,5);
 Menu->Add("     2400",57,70,6);
 Menu->Add("     4800",57,70,7);
 Menu->Add("     9600",57,70,8);
 Menu->Add("    19200",57,70,9);
 Menu->Add("    38400",57,70,10);
 Menu->Add("    57600",57,70,11);
 Menu->Add("   115200",57,70,12);
 Menu->Add("   230400",57,70,13);
 switch(Baud){
 case 300: Menu->Focus = 0; break;
 case 600: Menu->Focus = 1; break;
 case 1200: Menu->Focus = 2; break;
 case 2400: Menu->Focus = 3; break;
 case 4800: Menu->Focus = 4; break;
 case 9600: Menu->Focus = 5; break;
 case 19200: Menu->Focus = 6; break;
 case 38400: Menu->Focus = 7; break;
 case 57600: Menu->Focus = 8; break;
 case 115200: Menu->Focus = 9; break;
 case 230400: Menu->Focus = 10; break;
 default:break;
 }
 if ((Menu->Focus == 1 || Menu->Focus == 2) && WhichBook == 1) Menu->Focus = 3;
 Menu->Show();
 wrefresh(Window);

 Key = 0;
 while (Key != '\n' && Key != '\e'){
  Key = getEscChar();
  Menu->GetInput(Key);
 }
 if (Key == '\n'){
   if ((Menu->Focus == 1 || Menu->Focus == 2) && WhichBook == 1) Menu->Focus = 3;
   switch(Menu->Focus){
   case 0: Baud = 300; break;
   case 1: Baud = 600; break;
   case 2: Baud = 1200; break;
   case 3: Baud = 2400; break;
   case 4: Baud = 4800; break;
   case 5: Baud = 9600; break;
   case 6: Baud = 19200; break;
   case 7: Baud = 38400; break;
   case 8: Baud = 57600; break;
   case 9: Baud = 115200; break;
   case 10: Baud = 230400; break;
   default:break;
 }
 }
 
 delete Menu;
 delete Win;
 
 Window->_attrs = Attr;
 wmove(Window, y, x);
 return Baud;
}

int ChooseParity(WINDOW *Window, char Parity)
{
 int Key, Which, Center, y, x, Attr;
 tWindow *Win;
 tMenu *Menu;
 
 Attr = Window->_attrs;
 getyx(Window, y, x);
 Which = 0;
 Center = findCenter(0, COLS, 13);
 
 Win = new tWindow(Window, Center, (LINES-1)/2-1, Center+13+1,(LINES-1)/2+3, Integers[cMenu] >> 4, 
           Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Choose parity", Integers[cMenuTitle]);
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText],  ALIGNMID);
 Menu->Add("~N~one", Center+1, Center+13+1, (LINES-1)/2);
 Menu->Add("~O~dd ", Center+1, Center+13+1, (LINES-1)/2+1);
 Menu->Add("~E~ven", Center+1, Center+13+1, (LINES-1)/2+2);
 switch(Parity){
 case 'N':
   Parity = 0;
   break;
 case 'O':
   Parity = 1;
   break;
 case 'E':
   Parity = 2;
   break;
 default:break;
 }
 Menu->Focus = Parity;
 Menu->Show();
 wrefresh(Window);

 Key = 0;
 while (Key != '\n'){
  Key = getEscChar();
  Menu->GetInput(Key);
  wrefresh(Window);
 }
 
 Which = Menu->Focus;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y, x);
 Window->_attrs = Attr;
 
 switch(Which){
 case 0:
   Which = 'N';
   break;
 case 1:
   Which = 'O';
   break;
 case 2:
   Which = 'E';
   break;
 default:break;
 }
 
 return Which; 
}

int ChooseDatabits(WINDOW *Window, char Databit)
{
 int Key, Which, Center, y, x, Attr;
 tWindow *Win;
 tMenu *Menu;
 
 Attr = Window->_attrs;
 getyx(Window, y, x);
 Which = 0;
 Center = findCenter(0, COLS, 17);
 
 Win = new tWindow(Window, Center, (LINES-1)/2-1, Center+17+1,(LINES-1)/2+2, Integers[cMenu] >> 4, 
           Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Choose databits", Integers[cMenuTitle]);
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText],  ALIGNMID);
 Menu->Add("~7~", Center+1, Center+17+1, (LINES-1)/2);
 Menu->Add("~8~", Center+1, Center+17+1, (LINES-1)/2+1);
 Menu->Focus = Databit-7;
 Menu->Show();
 wrefresh(Window);

 Key = 0;
 while (Key != '\n'){
  Key = getEscChar();
  Menu->GetInput(Key);
  wrefresh(Window);
 }
 
 Which = Menu->Focus+7;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y, x);
 Window->_attrs = Attr;
 
 return Which; 
}

int ChooseStopbits(WINDOW *Window, char Stopbit)
{
 int Key, Which, Center, y, x, Attr;
 tWindow *Win;
 tMenu *Menu;
 
 Attr = Window->_attrs;
 getyx(Window, y, x);
 Which = 0;
 Center = findCenter(0, COLS, 17);
 
 Win = new tWindow(Window, Center, (LINES-1)/2-1, Center+17+1,(LINES-1)/2+2, Integers[cMenu] >> 4, 
           Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Choose stopbits", Integers[cMenuTitle]);
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText],  ALIGNMID);
 Menu->Add("~1~", Center+1, Center+17+1, (LINES-1)/2);
 Menu->Add("~2~", Center+1, Center+17+1, (LINES-1)/2+1);
 Menu->Focus = Stopbit;
 Menu->Show();
 wrefresh(Window);

 Key = 0;
 while (Key != '\n'){
  Key = getEscChar();
  Menu->GetInput(Key);
  wrefresh(Window);
 }
 
 Which = Menu->Focus;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y, x);
 Window->_attrs = Attr;
 return Which; 
}

int ChooseFlow(WINDOW *Window, char Flow)
{
 int Key, Which, Center, y, x, Attr;
 tWindow *Win;
 tMenu *Menu;
 
 Attr = Window->_attrs;
 getyx(Window, y, x);
 Which = 0;
 Center = findCenter(0, COLS, 23);
 
 Win = new tWindow(Window, Center, (LINES-1)/2-1, Center+23+1,(LINES-1)/2+2, Integers[cMenu] >> 4, 
           Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Choose flow control", Integers[cMenuTitle]);
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText],  ALIGNLEFT);
 Menu->Add("[ ] ~H~ardware (CTS/RTS)", Center+1, Center+23+1, (LINES-1)/2);
 Menu->Add("[ ] ~S~oftware (XON/XOFF)", Center+1, Center+23+1, (LINES-1)/2+1);
 if (Flow & 1) *(((menuItem *)(Menu->Base))->Text+1) = 'x';
 if (Flow & 2) *(((menuItem *)(Menu->Base->Next))->Text+1) = 'x';
 Menu->Focus = 0;
 Menu->Show();
 wrefresh(Window);

 Key = 0;
 while (Key != '\n'){
  Key = getEscChar();
  Menu->GetInput(Key);
  if (Key == ' ') {
   Flow ^= Menu->Focus+1;
   if (Flow & 1) *(((menuItem *)(Menu->Base))->Text+1) = 'x';
   else *(((menuItem *)(Menu->Base))->Text+1) = ' ';
   if (Flow & 2) *(((menuItem *)(Menu->Base->Next))->Text+1) = 'x';
   else *(((menuItem *)(Menu->Base->Next))->Text+1) = ' ';
   Menu->Show();
  }
  wrefresh(Window);
 }
 
 Which = Flow;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y, x);
 Window->_attrs = Attr;
 return Which; 
}

int ChooseYesno(WINDOW *Window, char *Headline)
{
 int Key, Which, Center, y, x, Attr;
 tWindow *Win;
 tMenu *Menu;
 
 Attr = Window->_attrs;
 getyx(Window, y, x);
 Which = 0;
 Center = findCenter(0, COLS, strlen(Headline));
 
 Win = new tWindow(Window, Center, (LINES-1)/2-1, Center+strlen(Headline)+1,(LINES-1)/2+2, Integers[cMenu] >> 4,            Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline(Headline, Integers[cMenuTitle]);
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText],  ALIGNMID);
 Menu->Add("~Y~es", Center+1, Center+strlen(Headline)+1, (LINES-1)/2);
 Menu->Add("~N~o", Center+1, Center+strlen(Headline)+1, (LINES-1)/2+1);
 Menu->Focus = 1;
 Menu->Show();
 wrefresh(Window);

 Key = 0;
 while (Key != '\n'){
  Key = getEscChar();
  if (Menu->GetInput(Key) > 127) Key = '\n';
  wrefresh(Window);
 }
 
 Which = Menu->Focus ^ 1;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y, x);
 Window->_attrs = Attr;
 return Which; 
}

int ChooseUser(WINDOW *Window)
{
 int Key, i;
 tWindow *Win;
 char Temp[256];
 tMenu *Menu;
 menuItem *Tmp;

 Win = new tWindow(Window, 40,5,70,16, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Choose user, E - edits", Integers[cMenuTitle]);
 
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 for (i=0;i<10;i++)
 {
  if (strlen(Strings[User1+i])<28)
  {
   Menu->Add(Strings[User1+i], 41, 70, 6+i);
  }
  else
  {
   strncpy(Temp, Strings[User1+i], 28);
   Temp[28] = 0;
   Menu->Add(Temp, 41, 70, 6+i);
  }
 }
 Menu->Show();
 wrefresh(Window);
 
 Key = 0;
 while (Key != '\e' && Key != '\n'){
   Key = getEscChar();
   if (Key == 'e' || Key == 'E')
   {
    clearok(Window, TRUE);
    if (getstring(Window, 6+Menu->Focus, 41, Strings[User1+Menu->Focus],ValidEdit,"\n\e",29,-1,Temp) == '\n')
    {
     Strings[User1+Menu->Focus] = (char *)realloc(Strings[User1+Menu->Focus], strlen(Temp)+1);
     strcpy(Strings[User1+Menu->Focus], Temp);
     Tmp = Menu->Base;
     for (i=0;i<Menu->Focus;i++)
      Tmp = Tmp->Next;
     Tmp->Text = (char *)realloc(Tmp->Text, strlen(Temp)+1);
     strcpy(Tmp->Text, Temp);
    }
    Menu->Show();
    wrefresh(Window);
   }
   Menu->GetInput(Key);
 }
 
 i = Menu->Focus+1;
 
 delete Menu;
 delete Win;
 return i;
}

int ChoosePrefix(WINDOW *Window, int prefix)
{
 int Key, i, y, x;
 tWindow *Win;
 char Temp[256];
 tMenu *Menu;
 menuItem *Tmp;

 getyx(Window, y ,x);
 Win = new tWindow(Window, 40,5,70,12, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Choose prefix, E - edits", Integers[cMenuTitle]);
 
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 for (i=0;i<6;i++)
 {
  if (strlen(Strings[Prefix1+i])<28)
  {
   Menu->Add(Strings[Prefix1+i], 41, 70, 6+i);
  }
  else
  {
   strncpy(Temp, Strings[Prefix1+i], 28);
   Temp[28] = 0;
   Menu->Add(Temp, 41, 70, 6+i);
  }
 }
 Menu->Focus = prefix-1;
 Menu->Show();
 wrefresh(Window);
 
 Key = 0;
 while (Key != '\e' && Key != '\n'){
   Key = getEscChar();
   if (Key == 'e' || Key == 'E')
   {
    clearok(Window, TRUE);
    if (getstring(Window, 6+Menu->Focus, 41, Strings[Prefix1+Menu->Focus],ValidEdit,"\n\e",29,-1,Temp) == '\n')
    {
     Strings[Prefix1+Menu->Focus] = (char *)realloc(Strings[Prefix1+Menu->Focus], strlen(Temp)+1);
     strcpy(Strings[Prefix1+Menu->Focus], Temp);
     Tmp = Menu->Base;
     for (i=0;i<Menu->Focus;i++)
      Tmp = Tmp->Next;
     Tmp->Text = (char *)realloc(Tmp->Text, strlen(Temp)+1);
     strcpy(Tmp->Text, Temp);
    }
    Menu->Show();
    wrefresh(Window);
   }
   Menu->GetInput(Key);
 }
 
 if (WhichBook == 1) Menu->Focus &= 3;
 i = Menu->Focus+1;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y ,x);
 return i;
}

int ChooseSuffix(WINDOW *Window, int suffix)
{
 int Key, i, y, x;
 tWindow *Win;
 char Temp[256];
 tMenu *Menu;
 menuItem *Tmp;

 getyx(Window, y, x);
 Win = new tWindow(Window, 40,5,70,11, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Choose suffix, E - edits", Integers[cMenuTitle]);
 
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 for (i=0;i<5;i++)
 {
  if (strlen(Strings[Suffix1+i])<28)
  {
   Menu->Add(Strings[Suffix1+i], 41, 70, 6+i);
  }
  else
  {
   strncpy(Temp, Strings[Suffix1+i], 28);
   Temp[28] = 0;
   Menu->Add(Temp, 41, 70, 6+i);
  }
 }
 Menu->Focus = suffix-1;
 Menu->Show();
 wrefresh(Window);
 
 Key = 0;
 while (Key != '\e' && Key != '\n'){
   Key = getEscChar();
   if (Key == 'e' || Key == 'E')
   {
    clearok(Window, TRUE);
    if (getstring(Window, 6+Menu->Focus, 41, Strings[Suffix1+Menu->Focus],ValidEdit,"\n\e",29,-1,Temp) == '\n')
    {
     Strings[Suffix1+Menu->Focus] = (char *)realloc(Strings[Suffix1+Menu->Focus], strlen(Temp)+1);
     strcpy(Strings[Suffix1+Menu->Focus], Temp);
     Tmp = Menu->Base;
     for (i=0;i<Menu->Focus;i++)
      Tmp = Tmp->Next;
     Tmp->Text = (char *)realloc(Tmp->Text, strlen(Temp)+1);
     strcpy(Tmp->Text, Temp);
    }
    Menu->Show();
    wrefresh(Window);
   }
   Menu->GetInput(Key);
 }
 
 i = Menu->Focus+1;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y, x);
 return i;
}

int ChooseInit(WINDOW *Window, int init)
{
 int Key, i, y, x;
 tWindow *Win;
 char Temp[256];
 tMenu *Menu;
 menuItem *Tmp;

 getyx(Window, y, x);
 Win = new tWindow(Window, 40, 5, 70, 16, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Choose initstring, E - edits", Integers[cMenuTitle]);
 
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 for (i=0;i<10;i++)
 {
  if (strlen(Strings[InitStr1+i])<28)
  {
   Menu->Add(Strings[InitStr1+i], 41, 70, 6+i);
  }
  else
  {
   strncpy(Temp, Strings[InitStr1+i], 28);
   Temp[28] = 0;
   Menu->Add(Temp, 41, 70, 6+i);
  }
 }
 Menu->Focus = init;
 Menu->Show();
 wrefresh(Window);
 
 Key = 0;
 while (Key != '\e' && Key != '\n'){
   Key = getEscChar();
   if (Key == 'e' || Key == 'E')
   {
    clearok(Window, TRUE);
    if (getstring(Window, 6+Menu->Focus, 41, Strings[InitStr1+Menu->Focus], ValidEdit,"\n\e",29,-1,Temp) == '\n')
    {
     Strings[InitStr1+Menu->Focus] = (char *)realloc(Strings[InitStr1+Menu->Focus], strlen(Temp)+1);
     strcpy(Strings[InitStr1+Menu->Focus], Temp);
     Tmp = Menu->Base;
     for (i=0;i<Menu->Focus;i++)
      Tmp = Tmp->Next;
     Tmp->Text = (char *)realloc(Tmp->Text, strlen(Temp)+1);
     strcpy(Tmp->Text, Temp);
    }
    Menu->Show();
    wrefresh(Window);
   }
   Menu->GetInput(Key);
 }
 
 i = Menu->Focus;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y, x);
 return i;
}

int ChooseNoConnect(WINDOW *Window, int Noconnect)
{
 int Key, i, y, x;
 tWindow *Win;
 char Temp[256];
 tMenu *Menu;
 menuItem *Tmp;

 getyx(Window, y, x);
 Win = new tWindow(Window, 40,5,70,11, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Edit strings, E - edits", Integers[cMenuTitle]);
 
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 for (i=0;i<5;i++)
 {
  if (strlen(Strings[NoConnect1+i])<28)
  {
   Menu->Add(Strings[NoConnect1+i], 41, 70, 6+i);
  }
  else
  {
   strncpy(Temp, Strings[NoConnect1+i], 28);
   Temp[28] = 0;
   Menu->Add(Temp, 41, 70, 6+i);
  }
 }
 Menu->Focus = Noconnect;
 Menu->Show();
 wrefresh(Window);
 
 Key = 0;
 while (Key != '\e' && Key != '\n'){
   Key = getEscChar();
   if (Key == 'e' || Key == 'E')
   {
    clearok(Window, TRUE);
    if (getstring(Window, 6+Menu->Focus, 41, Strings[NoConnect1+Menu->Focus], ValidEdit,"\n\e",29,-1,Temp) == '\n')
    {
     Strings[NoConnect1+Menu->Focus] = (char *)realloc(Strings[NoConnect1+Menu->Focus], strlen(Temp)+1);
     strcpy(Strings[NoConnect1+Menu->Focus], Temp);
     Tmp = Menu->Base;
     for (i=0;i<Menu->Focus;i++)
      Tmp = Tmp->Next;
     Tmp->Text = (char *)realloc(Tmp->Text, strlen(Temp)+1);
     strcpy(Tmp->Text, Temp);
    }
    Menu->Show();
    wrefresh(Window);
   }
   Menu->GetInput(Key);
 }
 
 i = Menu->Focus;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y, x);
 return i;
}

int ChooseMacro(WINDOW *Window, int WhichMacro)
{
 int Key, i, y, x;
 tWindow *Win;
 char Temp[256];
 tMenu *Menu;
 menuItem *Tmp;

 getyx(Window, y, x);
 Win = new tWindow(Window, 40,5,70,16, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Edit macros, E - edits", Integers[cMenuTitle]);
 
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 for (i=0;i<10;i++)
 {
  if (strlen(Strings[Macro1+i])<28)
  {
   Menu->Add(Strings[Macro1+i], 41, 70, 6+i);
  }
  else
  {
   strncpy(Temp, Strings[Macro1+i], 28);
   Temp[28] = 0;
   Menu->Add(Temp, 41, 70, 6+i);
  }
 }
 Menu->Focus = WhichMacro;
 Menu->Show();
 wrefresh(Window);
 
 Key = 0;
 while (Key != '\e' && Key != '\n'){
   Key = getEscChar();
   if (Key == 'e' || Key == 'E')
   {
    clearok(Window, TRUE);
    if (getstring(Window, 6+Menu->Focus, 41, Strings[Macro1+Menu->Focus], ValidEdit,"\n\e",29,-1,Temp) == '\n')
    {
     Strings[Macro1+Menu->Focus] = (char *)realloc(Strings[Macro1+Menu->Focus], strlen(Temp)+1);
     strcpy(Strings[Macro1+Menu->Focus], Temp);
     Tmp = Menu->Base;
     for (i=0;i<Menu->Focus;i++)
      Tmp = Tmp->Next;
     Tmp->Text = (char *)realloc(Tmp->Text, strlen(Temp)+1);
     strcpy(Tmp->Text, Temp);
    }
    Menu->Show();
    wrefresh(Window);
   }
   Menu->GetInput(Key);
 }
 
 i = Menu->Focus;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y, x);
 return i;
}

int ChooseDeviceInit(WINDOW *Window, int Which)
{
 int Key, i, y, x, j, len;
 tWindow *Win;
 char TempInit[4][11], Temp[256];
 tMenu *Menu;
 menuItem *Tmp;

 getyx(Window, y, x);
 Win = new tWindow(Window, 40,5,70,10, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Edit strings, E - edits", Integers[cMenuTitle]);
 
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 for (i=0;i<4;i++){
 len = 0;
  for (j=0;j<10;j++)
   if (DeviceInit[i][j] >= 0){
    len++;
    TempInit[i][j] = DeviceInit[i][j]+48;
   }
 TempInit[i][len] = 0;
 }
 
 for (i=0;i<4;i++)
 {
  if (strlen(TempInit[i])<28)
  {
   Menu->Add(TempInit[i], 41, 70, 6+i);
  }
  else
  {
   strncpy(Temp, TempInit[i], 28);
   Temp[28] = 0;
   Menu->Add(Temp, 41, 70, 6+i);
  }
 }
 Menu->Focus = Which;
 Menu->Show();
 wrefresh(Window);
 
 Key = 0;
 while (Key != '\e' && Key != '\n'){
   Key = getEscChar();
   clearok(Window, TRUE);
   Menu->GetInput(Key);
   if (Key == 'e' || Key == 'E')
   {
    clearok(Window, TRUE);
    if (getstring(Window, 6+Menu->Focus, 41, TempInit[Menu->Focus],NumberEdit,"\n\e",29,-1,Temp) == '\n')
    {
     strcpy(TempInit[Menu->Focus], Temp);
     Tmp = Menu->Base;
     for (i=0;i<Menu->Focus;i++)
      Tmp = Tmp->Next;
     Tmp->Text = (char *)realloc(Tmp->Text, strlen(Temp)+1);
     strcpy(Tmp->Text, Temp);
    }
    Menu->Show();
    wrefresh(Window);
   }
 }
 
 for (i=0;i<4;i++){
  len = strlen(TempInit[i]);
  for (j=0;j<10;j++)
   if (j < len)
    DeviceInit[i][j] = TempInit[i][j]-48;
   else
    DeviceInit[i][j] = -1;
 }
 
 i = Menu->Focus;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y, x);
 return i;
}

int ChooseTerminal(WINDOW *Window, int Terminal)
{
 int Key, i, Attr, y, x;
 tWindow *Win;
 tMenu *Menu;

 getyx(Window, y, x);
 Attr = Window->_attrs;
 Win = new tWindow(Window, 20,5,70,11, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 Win->Headline("Choose terminal", Integers[cMenuTitle]);
 
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 for (i=0;i<5;i++)
 {
  Menu->Add(TermEmu[i], 21, 70, 6+i);
 }
 Menu->Focus = Terminal;
 Menu->Show();
 wrefresh(Window);
 
 Key = 0;
 while (Key != '\e' && Key != '\n'){
   Key = getEscChar();
   Menu->GetInput(Key);
 }
 
 i = Menu->Focus;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y, x);
 Window->_attrs = Attr;
 return i;
}

int ChooseDevice(WINDOW *Window, int Device, char Configure)
{
 int Key, i, Attr, y, x;
 tWindow *Win;
 char Temp[256];
 tMenu *Menu;
 menuItem *Tmp;

 getyx(Window, y, x);
 Attr = Window->_attrs;
 Win = new tWindow(Window, 20,5,70,11, Integers[cMenu] >> 4, Integers[cMenu] % 16);
 Win->Frame(1, Integers[cMenu]);
 if (Configure)
  Win->Headline("Edit strings, E - edits, O - options", Integers[cMenuTitle]);
 else
  Win->Headline("Edit strings, E - edits", Integers[cMenuTitle]);
 
 Menu = new tMenu(Window, Integers[cMenu], Integers[cMenuHot], Integers[cMenuBar], Integers[cMenuText], ALIGNLEFT);
 Menu->Add("Default device", 21, 70, 6);
 for (i=0;i<4;i++)
 {
  if (strlen(Strings[Device1+i])<48)
  {
   Menu->Add(Strings[Device1+i], 21, 70, 7+i);
  }
  else
  {
   strncpy(Temp, Strings[Device1+i], 48);
   Temp[48] = 0;
   Menu->Add(Temp, 21, 70, 7+i);
  }
 }
 Menu->Focus = Device;
 Menu->Show();
 wrefresh(Window);
 
 Key = 0;
 while (Key != '\e' && Key != '\n'){
   Key = getEscChar();
   Menu->GetInput(Key);
   if (Key == 'e' || Key == 'E')
   {
    if (Menu->Focus != 0){
     clearok(Window, TRUE);
     if (getstring(Window, 6+Menu->Focus, 21, Strings[Device1+Menu->Focus-1],FileEdit,"\n\e",49,-1,Temp) == '\n')
     {
      Strings[Device1+Menu->Focus-1] = (char *)realloc(Strings[Device1+Menu->Focus-1], strlen(Temp)+1);
      strcpy(Strings[Device1+Menu->Focus-1], Temp);
      Tmp = Menu->Base;
      for (i=0;i<Menu->Focus;i++)
       Tmp = Tmp->Next;
      Tmp->Text = (char *)realloc(Tmp->Text, strlen(Temp)+1);
      strcpy(Tmp->Text, Temp);
     }
    }
   }
   if ((Key == 'o' || Key == 'O') && (Configure)){
    if (Menu->Focus != 0){
     Integers[Bauds1+Menu->Focus-1] = ChooseBaud(Window, Integers[Bauds1+Menu->Focus-1]);
     clearok(Window, TRUE);
     Integers[Parities1+Menu->Focus-1] = ChooseParity(Window, Integers[Parities1+Menu->Focus-1]);
     clearok(Window, TRUE);
     Integers[Databits1+Menu->Focus-1] = ChooseDatabits(Window, Integers[Databits1+Menu->Focus-1]);
     clearok(Window, TRUE);
     Integers[Stopbits1+Menu->Focus-1] = ChooseStopbits(Window, Integers[Stopbits1+Menu->Focus-1]);
     clearok(Window, TRUE);
     Integers[FlowCtrl1+Menu->Focus-1] = ChooseFlow(Window, Integers[FlowCtrl1+Menu->Focus-1]);
     clearok(Window, TRUE);
    }
   }
   Menu->Show();
   wrefresh(Window);
 }
 
 i = Menu->Focus;
 
 delete Menu;
 delete Win;
 
 wmove(Window, y, x);
 Window->_attrs = Attr;
 return i;
}

int chwait()
{
 fd_set set;
 timeval timeout;
 
 timeout.tv_sec = 0;
 timeout.tv_usec = 20;
 
 FD_ZERO(&set);
 FD_SET(0, &set);
 if (select(1, &set, NULL, NULL, &timeout) > 0)
 {
  if (FD_ISSET(0, &set)) return TRUE;
 }
 return FALSE;
}

