/*
    utils.h -- Header file for utility routines
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef __UTILS_H_
#define __UTILS_H_

#include "window.h"

extern int Year, Month, Day;

void OpenCaptureFile(WINDOW *Window, char *CaptureName);
void DisplayMessage(WINDOW *Window, char *Text, int sleeptime);
char *nocasestrstr(char *Haystack, char *Needle);
int ValidName(char *Str, char *Putin);
//void FromJulian(int Date);
void ReplaceM(char *s);
void MacroParser(char *s, char *Username, char *Pwd);
void ProtocolParser(char *s, char *Dl, char *Device, int Baud, char *Filename);
void Julian(int Jul);
void PasToChar(char *Pas, char *Char);
void CharToPas(char *Pas, char *Char);
int ColorChoose(WINDOW *Window, int Color);
long int ChooseBaud(WINDOW *Window, long int Baud);
int ChooseParity(WINDOW *Window, char Parity);
int ChooseDatabits(WINDOW *Window, char Databit);
int ChooseStopbits(WINDOW *Window, char Stopbit);
int ChooseFlow(WINDOW *Window, char Flow);
int ChooseYesno(WINDOW *Window, char *Headline);
int ChooseUser(WINDOW *Window);
int ChoosePrefix(WINDOW *Window, int prefix);
int ChooseSuffix(WINDOW *Window, int suffix);
int ChooseInit(WINDOW *Window, int init);
int ChooseDeviceInit(WINDOW *Window, int Which);
int ChooseMacro(WINDOW *Window, int WhichMacro);
int ChooseNoConnect(WINDOW *Window, int Noconnect);
int ChooseTerminal(WINDOW *Window, int Terminal);
int ChooseDevice(WINDOW *Window, int Device, char Configure);
int chwait();
#endif
