/*
    window.c -- Windows in OOP.
    Copyright (C) 1996  Nadav Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "window.h"
#include "screen.h"
#include <stdlib.h>

tWindow::tWindow(WINDOW *Win, int x1, int y1, int x2, int y2, int bColor, int fColor)
{
 int x, y, fcol, bcol;
 chtype *tmp;
 
 Window = Win;
 X1 = x1;
 X2 = x2;
 Y1 = y1;
 Y2 = y2;
 bgColor = bColor;
 fgColor = fColor;
 
 bkgd = malloc(sizeof(chtype)*(x2-x1+1)*(y2-y1+1));
 tmp = (chtype *)bkgd;
 
 fcol = fgCol;
 bcol = bgCol;
 textColor(Window, fgColor);
 textBkgd(Window, bgColor);
 for (y=y1;y<=y2;y++)
  for (x=x1;x<=x2;x++)
  {
   *tmp = mvwinch(Window, y, x);
   mvwaddch(Window, y, x, ' ');
   tmp++;
  }
 textColor(Window, fcol);
 textBkgd(Window, bcol);
};

tWindow::~tWindow()
{
 int x,y;
 chtype *tmp;
 
 tmp = (chtype *)bkgd;
 for (y=Y1;y<=Y2;y++)
  for (x=X1;x<=X2;x++)
  {
   wattrset(Window, COLOR_PAIR(*tmp & A_COLOR) | *tmp & A_ATTRIBUTES);
   mvwaddch(Window, y, x, *tmp);
   tmp++;
  }
 
 free(bkgd);
}

void tWindow::Frame(int Which, int Color)
{
 int sx, sy, fcolor, bcolor;
 int HLINE, VLINE, UL, UR, BL, BR;
 
 fcolor = fgCol;
 bcolor = bgCol;
 textColor(Window, Color % 16);
 textBkgd(Window, Color >> 4);
 getyx(Window, sy, sx);
 
 /* 1 for single, 2 for double */
 if (Which == 1) {
  HLINE = SHLINE;
  VLINE = SVLINE;
  UL = SUL;
  UR = SUR;
  BL = SBL;
  BR = SBR;
 }
 else
 {
  HLINE = DHLINE;
  VLINE = DVLINE;
  UL = DUL;
  UR = DUR;
  BL = DBL;
  BR = DBR;
 }
 wmove(Window, Y1, X1);
 whline(Window, HLINE, X2-X1);
 wmove(Window, Y2, X1);
 whline(Window, HLINE, X2-X1);
 wmove(Window, Y1, X1);
 wvline(Window, VLINE, Y2-Y1);
 wmove(Window, Y1, X2);
 wvline(Window, VLINE, Y2-Y1);
 wmove(Window, Y1, X1);
 waddch(Window, UL);
 wmove(Window, Y1, X2);
 waddch(Window, UR);
 wmove(Window, Y2, X1);
 waddch(Window, BL);
 wmove(Window, Y2, X2);
 waddch(Window, BR);
 textColor(Window, fcolor);
 textBkgd(Window, bcolor);
 wmove(Window, sy, sx);
}

void tWindow::Headline(char *Text, int Color)
{
 int x, len, fcol, bcol, sx, sy;
 
 getyx(Window, sy, sx);
 fcol = fgCol;
 bcol = bgCol;
 len = strlen(Text);
 x = findCenter(X1, X2, len);
 wmove(Window, Y1, x);
 textColor(Window, Color % 16);
 textBkgd(Window, Color >> 4);
 waddstr(Window, Text);
 textColor(Window, fcol);
 textBkgd(Window, bcol);
 wmove(Window, sy, sx);
}
