/*
 * These are my own buffered I/O routines. They form a linked list of
 * blocks to be written which are flushed in as large chunks as possible.
 * These are used to increase the performance of the system as a whole.
 */

#ifdef NeXT
#include <libc.h>
#else
#include <stdio.h>
#include <fcntl.h>
#include <malloc.h>
#endif
#include "blocks.h"

/*
 * simple function to return amount of data in a list
 */

long
block_size(struct block_list *b)
{
    return b->stored;
    return 0;
}


/*
 * Initialise a blank block and associate it with a file descriptor. The
 * file descriptor is set to be non-blocking for i/o.
 */

void
block_init(struct block_list *b, int fd)
{
    b->first=NULL;
    b->last=NULL;
    b->fd=fd;
    b->stored=0;
    fcntl(fd, F_SETFL, FNDELAY);
}

/*
 * Here we add a character to a block list, creating a new block if
 * necessary.
 */

void
add_char(struct block_list *b, unsigned char c)
{
    register struct data_block *db=b->last;

    /* totally empty list */
    if(!db) {
	db=malloc(sizeof(struct data_block));
  	if(!db)
	    return;
	db->data[0]=c;
	db->len=1;
	db->offset=0;
	db->next=NULL;
	b->first=b->last=db;
	b->stored=1;
	return;
    }

    /* room in last block */
    if(db->len<DATA_LEN) {
	db->data[db->len]=c;
	db->len++;
	b->stored++;
	return;
    }

    /* need another block */
    db->next=malloc(sizeof(struct data_block));
    db=db->next;
    if(!db)
	return;
    db->data[0]=c;
    db->len=1;
    db->offset=0;
    db->next=NULL;
    b->last=db;
    b->stored++;
}

/*
 * Here we attempt to flush a block. As many characters as possible are
 * written to the device. The number of actual characters written is
 * returned.
 */

int
flush_block(struct block_list *b)
{
    register struct data_block *db=b->first;
    int written;

    if(!db)
	return 0;
    written=db->len-db->offset;
    written=write(b->fd,db->data+db->offset,written);
    db->offset+=written;
    b->stored-=written;

    /* possibly remove block */
    if(db->offset==db->len) {
	b->first=db->next;
	free(db);
	if(!b->first)
	    b->last=NULL;
    }

    return written;
}
