/*
 * This function deals with an actual call. It sets up the call and
 * then shuffles bytes between the sockets. IAC bytes are detected and
 * a function called to deal with them. This loop forms the heart of
 * the program. If this function fails it returns a 1, else a 0.
 */

#include <sys/time.h>
#include <sys/types.h>
#include "virtmodem.h"
#include "blocks.h"

#define BUFFER 4096		/* we can still saturate this ! */
#define MAX_TOGO 8192

extern struct block_list local;
struct block_list remote;

int
do_call(char*c)
{
    int fd;

    /* strip leading spaces */
    while((*c==' ') || (*c=='\t'))
	c++;

    /* make the call */
    if ((fd=call_tcp(c))==-1)
	return 1;
    stats_call(c);
    outstr("CONNECT TCP\r\n");

    /* setup block buffers */
    while(flush_block(&local));	/* make sure it's flushed */
    block_init(&local,1);
    block_init(&remote,fd);

    for (;;) {
	fd_set rmask, wmask;

	FD_ZERO(&rmask);
	FD_ZERO(&wmask);

	/* set appropriate masks */
	if(block_size(&local)<MAX_TOGO)
	    FD_SET(fd,&rmask);		/* can buffer more */
	if(block_size(&local)>0)
	    FD_SET(1,&wmask);		/* something to send */
	if(block_size(&remote)<MAX_TOGO)
	    FD_SET(0,&rmask);		/* can buffer more */
	if(block_size(&remote)>0)
	    FD_SET(fd,&wmask);		/* something to send */

	/* find a ready descriptor */
	if (select(fd+1, &rmask, &wmask, 0, 0)==-1)
	    return 0;

	/* test for writes */
	if (FD_ISSET(1,&wmask))
	    if(!flush_block(&local))
		return 0;
	if (FD_ISSET(fd,&wmask))
	    if(!flush_block(&remote))
		return 0;

	/* read from the socket */
	if (FD_ISSET(fd,&rmask)) {
	    unsigned char buf[BUFFER];
	    int len,i;

	    len=read(fd,buf,BUFFER);
	    if(!len)
		return 0;

	    add_pkt(0,len);
	    for(i=0;i<len;i++)
		telnet_byte(buf[i]);
	    flush_block(&remote);
	    flush_block(&local);
	}

	/* read from the terminal */
	if (FD_ISSET(0,&rmask)) {
	    unsigned char buf[BUFFER];
	    int len,i;

	    len=read(0,buf,BUFFER);
	    if(!len)
		return 0;

	    add_pkt(1,len);
	    for(i=0;i<len;i++) {
		unsigned char c=buf[i];
		if(c==255)
		    add_char(&remote,c);
		add_char(&remote,c);
	    }
	    if(!flush_block(&remote))
		return 0;
	}
    }
}
