/*
 * This file provides rudimentary support for the hayes command set. It
 * was written to enable simple calling scripts designed for serail port
 * modems to work without much modification. The function is passed the
 * string following the AT command. A 1 is returned if the, caller is
 * required to exit, else a 0.
 */

#include <string.h>
#include <fcntl.h>
#include "virtmodem.h"

int
command(char* c)
{
    switch(c[0]) {

    case 'z' :		/* AT and ATZ do nothing but print OK */
    case 'Z' :
    case '\0' :
	outstr("OK\n\r");
	break;

    case 'h' :		/* simply wait one second and exit */
    case 'H' :
	outstr("OK\n\r");
	sleep(1);
	return 1;
	break;

    case 'd' :		/* dial a particular string and print a message */
    case 'D' :		/* upon completion of the call */
	c++;

	/* strip any extraneous commands with space separator */
	if(strchr(c,' ')) {
		c=strchr(c,' ');
		while(*c==' ')
		    c++;
	}

	if(do_call(c))
	    outstr("NO DIALTONE\n\r");
	else 
	    outstr("NO CARRIER\n\r");
        fcntl(0, F_SETFL, 0);	/* set blocking */
	stats_end();
	break;

    default:
	outstr("BAD COMMAND\n\r");
    }
    return 0;
}
