/*
 * This function deals with the telnet protocol for turning options
 * on and off. It basically refuses to do anything that the far end
 * asks it to and agrees tthat the far end should do anything it
 * wants to. This is done by modifying the original IAC string and
 * then returning it.
 */

#include "virtmodem.h"
#include "blocks.h"

extern struct block_list remote;

#define WILL 251
#define WONT 252
#define DO 253
#define DONT 254

void
do_iac(unsigned char b[3])
{
    int i;
    b[0]=255;
    switch(b[1]) {
    case WILL:
	b[1]=DO;
	break;
    case WONT:
	b[1]=DONT;
	break;
    case DO:
    case DONT:
	b[1]=WONT;
	break;
    default:
	outstr("BAD IAC\r\n");
    }

    /* add new IAC to return stream */
    for(i=0;i<3;i++)
	add_char(&remote,b[i]);
}
