/*
 * This function attaches the code to the first free pty. It
 * possibly forks (depending on the value of daemon) and reports
 * the name of the tty to stdout or stderr depending on whether
 * a fork was done. This is so that programs can use shell back-quoting
 * to get the name of the tty if they run virtmodem automatically.
 */

#include <stdio.h>
#include "virtmodem.h"

void
attach_pty(int daemon)
{
    char ttname[100];
    char *i, *j;
    int fd;

    strcpy(ttname, "/dev/XtyXX");	/* ugly hard-coded offsets */
    ttname[5] = 'p';
    for (i = "pqr"; *i; i++)
	for (j = "0123456789abcdef"; *j; j++) {

	    /* setup tty name and try to open it */
	    ttname[8] = *i;
	    ttname[9] = *j;
	    if ((fd = open(ttname, 2)) != -1) {
		ttname[5] = 't';	/* change pty to tty */
		if(daemon) {		/* possibly fork */
		    if(fork()) {
			puts(ttname);
			exit(0);
		    }
		} else
		    fprintf(stderr,"Running on terminal %s\n",ttname);

		/* close terminal and dup descriptors */
		fclose(stdin);
		fclose(stdout);
		fclose(stderr);
		dup2(fd,0);
		dup2(fd,1);
		dup2(fd,2);
		return;
	    }
	}
/* failed */
fprintf(stderr,"No free tty/pty pairs\n");
exit(1);
}
