/*
**
**  Internal header file for editline library.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h> 
#include "../xc.h"

#if _POSIX_SOURCE && !defined(unix)
#  define unix 1
#endif

#ifdef unix
#  include <unistd.h>
#  if HAVE_TERMCAP
#    define USE_TERMCAP 1
#    include <termcap.h>
#  endif
#  if _POSIX_SOURCE
#    define HAVE_TCGETATTR 1
#    define USE_DIRENT 1 
#  endif
#endif

#ifdef OS2
#include <conio.h>
#define SEPST "\\"
#define SEPCH '\\'
#endif

#ifdef MSDOS
#ifndef __MSDOS__
#define __MSDOS__
#endif
#endif

#ifdef DJD
#ifndef __MSDOS__
#define __MSDOS__
#endif
#endif

#if defined(__MSDOS__) || defined(WIN32)
#include <io.h>
#ifndef DJD
#include "msdos.h"
#ifndef WIN32
#include <conio.h>
#endif
#endif
#define SEPST "\\"
#define SEPCH '\\'
#endif

#if	defined(SYS_UNIX)
#include "unix.h"
#ifndef DJD
#define SEPST "/"
#define SEPCH '/'
#endif
#endif	/* defined(SYS_UNIX) */

#if	defined(SYS_OS9)
#include "os9.h"
#endif	/* defined(SYS_OS9) */

#define SIZE_T size_t
#if	!defined(SIZE_T)
#define SIZE_T	unsigned int
#endif	/* !defined(SIZE_T) */

typedef char CHAR; 
typedef int UNSI;

#define MEM_INC		64
#define SCREEN_INC	256

#if defined(__TURBOC__) && defined(ATPDMM)
#include "myheap.h"
#define DISPOSE(p)	myfree((char *)(p))
#define NEW(T, c) ((T *)mymalloc((unsigned int)(sizeof (T) * (c))))
#define RENEW(p, T, c) (p = (T *)myrealloc((char *)(p), (unsigned int)(sizeof (T) * (c))))
#else /* normal */
#define DISPOSE(p)	free((char *)(p))
#define NEW(T, c) ((T *)malloc((unsigned int)(sizeof (T) * (c))))
#define RENEW(p, T, c) (p = (T *)realloc((char *)(p), (unsigned int)(sizeof (T) * (c))))
#endif
#define COPYFROMTO(new, p, len) (void)memcpy((char *)(new), (char *)(p), (int)(len))

/* ms_dos key codes 
#define KLT 0x4b
#define KRT 0x4d
#define KUP 0x48
#define KDN 0x50
#define KHM 0x47
#define KPU 0x49
#define KPD 0x51
#define KEN 0x4f
#define KIN 0x52
#define KDL 0x53
#define KCE 0x4c
#define KF1 0x3b
#define KF2 0x3c
#define KF3 0x3d
#define KF4 0x3e
*/

/* ansi */

#define ESC 0x1b
#define KLT 'D' /* left */
#define KRT 'C' /* right */
#define KUP 'A' /* up */
#define KDN 'B' /* down */
#define KCE 'G' /* center */
#define KHM 'H' /* home */
#define KPU '5' /* page up */
#define KPD '6' /* page down */
#define KEN 'Y' /* end */
#define KIN '2' /* insert */
#define KDL '3' /* delete */
#define KF1 'P' /* f1 */
#define KF2 'Q' /* f2 */
#define KF3 'R' /* f3 */
#define KF4 'S' /* f4 */
#define KF5 'T' /* f5 */
#define KF6 'U' /* f6 */
#define KF7 'V' /* f7 */
#define KF8 'W' /* f8 */
#define KF9 'X' /* f9 */
#define KF0 'O' /* f10 */


/*
**  Variables and routines internal to this package.
*/
extern int	rl_eof;
extern int	rl_erase;
extern int	rl_intr;
extern int	rl_kill;
extern int	rl_quit;
 
extern char *rl_complete (char *, int *);
extern int  rl_list_possib (char *, char ***);
extern void	rl_ttyset (int);
extern void	rl_add_slash (char *, char *);

/*
#ifdef NO_STDLIB
extern char	*getenv();
extern char	*malloc();
extern char	*realloc();
extern char	*memcpy();
extern char	*strcat();
extern char	*strchr();
extern char	*strrchr();
extern char	*strcpy();
extern char	*strdup();
extern int	strcmp();
extern int	strlen();
extern int	strncmp();
#endif	
*/
