/* editline.c  prototypes */

/*
**  Command status codes.
*/
#define CASE enum TOULR
CASE { TOupper, TOlower } ;
#define STATUS enum RSTAT
STATUS { CSdone, CSeof, CSmove, CSdispatch, CSstay } ;

 char *readline( char *prompt, int scrollflag);
 void add_history(char *p);
 void columns(int ac, CHAR **av);
 void TTYflush(void);
 static void TTYput( const CHAR c);
 static void TTYputs( const CHAR *p);
 static void TTYshow( CHAR c);
 static void TTYstring( CHAR *p);
 static UNSI TTYget(void);
 static void TTYbackn(int n);
 static void TTYinfo(void);
 static void reposition(void);
 static void left(STATUS Change);
 static void right(STATUS Change);
 static STATUS ring_bell(void);
 static STATUS do_macro(unsigned int c);
 static STATUS do_forward(STATUS move);
 static STATUS do_case(CASE type);
 static STATUS case_down_word(void);
 static STATUS case_up_word(void);
 static void ceol(void);
 static void clear_line(void);
 static STATUS insert_string(CHAR *p);
 static CHAR *next_hist(void);
 static CHAR *prev_hist(void);
 static STATUS do_insert_hist(CHAR *p);
 static STATUS do_hist(CHAR *(*move)());
 static STATUS h_next(void);
 static STATUS h_prev(void);
 static STATUS h_first(void);
 static STATUS h_last(void);
 static int substrcmp(const char *text, const char *pat, SIZE_T len);
 static CHAR *search_hist(CHAR *search, CHAR *(*move)());
 static STATUS h_search(void);
 static STATUS fd_char(void);
 static void save_yank(int begin, int i);
 static STATUS delete_string(int count);
 static STATUS bk_char(void);
 static STATUS bk_del_char(void);
 static STATUS redisplay(void);
 static STATUS kill_line(void);
 static STATUS insert_char(int c);
 static STATUS meta(void);
 static STATUS emacs(unsigned int c);
 static STATUS TTYspecial(unsigned int c);
 static CHAR *editinput(void);
 static void hist_add(CHAR *p);
 void rl_reset_terminal(char *p);
 void rl_initialize(void);
 static STATUS beg_line(void);
 static STATUS del_char(void);
 static STATUS end_line(void);
 static CHAR *find_word(void);
 static STATUS c_complete(void);
 static STATUS c_possible(void);
 static STATUS accept_line(void);
 static STATUS transpose(void);
 static STATUS quote(void);
 static STATUS wipe(void);
 static STATUS mk_set(void);
 static STATUS exchange(void);
 static STATUS yank(void);
 static STATUS copy_region(void);
 static STATUS move_to_char(void);
 static STATUS fd_word(void);
 static STATUS fd_kill_word(void);
 static STATUS bk_word(void);
 static STATUS bk_kill_word(void);
 static int argify(CHAR *line_p, CHAR ***avp);
 static STATUS last_argument(void);
extern char *luxptr ;
