/* xc.h -- header  file for XC */

/*
 * Disable assert() for release version by defining NDEBUG.
 */

#define NDEBUG 1

/* 
 * Define XC_PLUS to 1 to enable extensions to xc 
 */

#define XC_PLUS 1

/* 
 * Define RLINE  to 1 if you wish to link with the included editline library 
 */

#define RLINE 1

/* 
 * Define HAVE_SELECT to 1 if your system supports the select() system call 
 */

#define HAVE_SELECT 1

/* 
 * Define HAVE_TERMCAP_H to 1 if your system provides termcap.h 
 */

#define HAVE_TERMCAP_H 1

/* 
 * Define HAVE_VT102 if you will primarily be using XC with a console
 * or terminal compatible with the VT102 family of terminals. This 
 * option is primarily to take advantage of the line graphics character
 * sets available on these terminals.
 */

#define HAVE_VT102 1


/* Local preferences and modems */

/*	CAPTFILE
	This is the default name given to the capture buffer in terminal mode (and
	during script processing). You can always reset this while running the
	program.
*/
#define	CAPTFILE "capture.log"	/* Default capture file */

/*	LIBDIR
	This is the default name given to a directory where PHFILE, STARTUP, and
	any XC scripts might be found. XC will search for such files
		1st) in a path in a colon-separated list of directories in
			 XC_PATH, if such an environment variable exists,
		2nd) in the current directory,
		3rd) in your HOME directory, if HOME is an environment variable,
		4th) in LIBDIR.
*/
#define LIBDIR "/usr/local/lib/xc"

/*	PHFILE
	This is the default name given to the dialing directory.
*/
#define PHFILE "phonelist"	/* Default phonelist file */

/*	STARTUP
	This is the default name of the startup script for XC. If this file is
	found it will be executed immediately on XC startup.
*/
#define STARTUP "xc.init"	/* XC Startup Script */

/*	DIALSTR
	A format string to send a telephone number to the modem with the
	appropriate dialing command.
*/

#define TONE_DIAL  "ATDT"  /* TONE dial command prefix */
#define PULSE_DIAL "ATDP"  /* PULSE dial command prefix */

#define DIALSTR TONE_DIAL "%s\r" /* printf format for modem dial command */

/*#define DIALSTR "AA" TONE_DIAL "%s\r"	 printf format for older Telebits */

/*	DTR_DROPS_CARRIER
  	On some (most?) modems, dropping the DTR signal will instruct
  	the modem to disconnect the phone line. On most (some?) Unix
  	systems, setting a bit/second rate of 0 will drop carrier.
  	
  	If either of these conditions do NOT apply to your setup,
  	set this value to 0 and an alternate hangup function will be
  	used. This alternate function sends the modem the ATTEN string,
  	waits a few seconds, and then sends the HANGUP string, so check
  	if those are correct for your modem.  
 */

#define	DTR_DROPS_CARRIER 1
#if !DTR_DROPS_CARRIER		/* If not, then we need the next two defines */
#define ATTEN "+++"		/* Modem "attention" signal */
#define HANGUP "ATH\r"		/* Modem "hang up" command */
#endif

/* DEBUG
	If this manifest is set to 1, then whenever XC is run within a
	directory that contains a file called "debug.log", XC will append to
	that file a copy of all XC output, whether to the terminal "file" or
	to standard error. This can be useful for debugging scripts, coupled
	with the "debug" script command, which causes the lines of a script
	to be echoed to the terminal as they get executed. Since often such
	output passes up the terminal screen too quickly to read, the
	"debug.log" file provides a hard-copy of the XC session.
	No echoing to a "debug.log" file is done if XC is also capturing
	incoming text to a capture file. If no "debug.log" file exists in the
	current directory, then no such echoing is done regardless of whether
	the DEBUG is here defined as 0 or 1.
*/
#define DEBUG 1
#if DEBUG && !NODEBUG
#define fprintf Fprintf
#define fputc Fputc
#define fputs Fputs
#endif

/* NOSHELL
	Set this to 1 to disallow shell escapes. Both the "!" and "$" mechanisms
	from the XC prompt, and the analogous SHELL and PIPE keywords in scripts,
	silently do nothing. However the standard output of backquoted shell
	commands can still be assigned to a script variable.
*/
/* #define NOSHELL 0 */

/* The Half-Duplex mode is depreciated since it is rarely needed. However
   if you wish to enable this option define HALF_DUPLEX to 1 */

/* #define HALF_DUPLEX 1 */


/* For XC, the following definitions are significant:
	DIDO=0
		This will not include any of the LCK..file code respected by cu/uucp.
	DIDO=2
	DIDO=3
	DIDO=4
	DIDO=9
		For a Dial-In/Dial-Out port.

		2 is for SCO Xenix 2.2 which uses ungetty.
		3 is for SCO Xenix 2.3 whose getty is effectively a uugetty,
		  for SCO Unix, or for other sites using uugetty.
		4 is for Unix Sys V Release 4
		9 is for Linux (HDB UUCP style lockfiles)
*/

/* Lock files and such for xcport.c ... */

#define DIDO 9


/***************************************************************************
 This next section is only for non-POSIX systems. Remove -D_POSIX_SOURCE=1 
 from the CFLAGS in the Makefile and edit this section to suit your system.
***************************************************************************/

#if !_POSIX_SOURCE

/*	The return type returned by signal(). It is sometimes type "int"
	on non-POSIX systems. If this is the case for you, define RETSIGTYPE 
	to int.
 */
#define RETSIGTYPE void

/*	STRCHR and STRRCHR vs. INDEX and RINDEX
	Some Berkeley and Xenix systems have index() and rindex() which are
	functionally identical to the more standard strchr() and strrchr()
	functions. These two defines should be 0 if your Unix uses index and
	rindex instead of strchr and strrchr.
*/

#define	HAVE_STRCHR 1
#define	HAVE_STRRCHR 1
#if !HAVE_STRCHR
#define	strchr	index
#endif
#if !HAVE_STRRCHR
#define	strrchr	rindex
#endif

/*	DUP2
	dup2() is not included with all versions of Unix. If your implementation
	does not have dup2() (or if you are just not sure), define this as 0 and
	a functional equivalent will be included in the source code.
*/
#define	HAVE_DUP2 0

/*	STRSTR
	The draft Ansi C standard specifies the "strstr" function to return the
	position of a substring within a string. This is NOT included in many 
	Unix systems, so code for this function is included unless you define
	this as 1.
*/
#define	HAVE_STRSTR 0

/*	MEMSET
	This function is not on earlier implementations of Unix. Define
	this as 0 if you don't have it; making it 1 will not include our 
	equivalent code.
*/
#define HAVE_MEMSET 0


/*
 * If you have the following POSIX process control functions you can 
 * define them to 1. These are used when spawning sub-shells. Define 
 * them to 0 to use alternative functions.
 */

#define HAVE_SETPGID 0
#define HAVE_WAITPID 0
#if !HAVE_SETPGID
/* note: this only works when x == y == 0 */
#define setpgid(x,y) setpgrp()
#endif
#if !HAVE_WAITPID
#define waitpid(X,Y,Z) while(wait(Y)>=0)
#endif


/* If you don't have these typedefs in your /usr/include/sys/types.h, then
   the following should be defined to 0.
*/
#define HAVE_PID_T 0
#define HAVE_SPEED_T 0

#if !HAVE_PID_T
typedef short pid_t;
#endif
#if !HAVE_SPEED_T
typedef short speed_t;
#endif

/* declare xc supplied functions for non-standard systems */
#if !HAVE_STRSTR
extern char *strstr ();
#endif
#if !HAVE_MEMSET
extern void *memset (); 
#endif
#if !HAVE_DUP2
extern int dup2();
#endif

#endif  /* not _POSIX_SOURCE */

/*************************************************************************/
/* The reader is kindly invited to leave the rest of this just as it is! */
/*************************************************************************/

#define SOH		0x1	/* ^A */
#define STX		0x2	/* ^B */ 
#define ETX		0x3	/* ^C */
#define EOT		0x4	/* ^D */
#define ENQ		0x5	/* ^E */
#define ACK		0x6	/* ^F */
#define BEL		0x7	/* ^G */
#define DLE		0x10	/* ^P */
#define XON		0x11	/* ^Q */
#define XOFF		0x13	/* ^S */
#define NAK	 	0x15	/* ^U */
#define CAN		0x18	/* ^X */

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif
#define SUCCESS	1
#define FAILURE	0

#define NEWMODE	0
#define SIGMODE	1
#define OLDMODE	2

#define SM_BUFF	 256
#define LG_BUFF 2048
#define S	show(1,Msg)
#define S0(x)	show(0,x)
#define S1(x)	show(1,x)
#define S2(x)	show(2,x)

/*	I prefer this NIL macro to present a NIL pointer than most other
	variations that I have seen (eg, NULL, 0, or (cast) 0.
	Comme ci, comme ca. - larry gensch
*/
#ifndef NIL
#define	NIL(type)	(type *) 0
#endif

/* posix or non-posix? */

#if _POSIX_SOURCE
# define RETSIGTYPE void
# define DRAIN_FLAG !g_flag
# include <termios.h>
#else
# include <termio.h>
# define termios termio
# ifndef SIGCHLD
#   define SIGCHLD SIGCLD
# endif
# define tcgetattr(f,s)   ioctl(f,TCGETA,s)
# define tcsetattr(f,a,s) ioctl(f,TCSETAF,s) 
# define tcsendbreak(f,x) ioctl(f,TCSBRK,x)
# define cfgetospeed(X) (speed_t)((X)->c_cflag & CBAUD)
# define cfsetispeed(X,Y) (X)->c_cflag &= ~CBAUD; (X)->c_cflag |= Y
# define cfsetospeed(X,Y) (X)->c_cflag &= ~CBAUD; (X)->c_cflag |= Y
# ifndef STDIN_FILENO
#   define STDIN_FILENO 0
# endif
# define DRAIN_FLAG (!g_flag && (firstsec || badline ))
#endif /*not _POSIX_SOURCE*/

/* IXANY is not POSIX */
#ifndef IXANY
#define IXANY 0
#endif

/* replacement for termcap.h */
#if HAVE_TERMCAP_H
# include <termcap.h>
#else
extern speed_t ospeed;
extern int tgetent(char *bp, char *name);
extern int tgetnum(char *id);
extern int tputs(register char *cp, int affcnt, int (*outc)());
#endif

/* arguments for call to readbyte() */
#ifdef HAVE_SELECT
#  define RB_POLL   0
#  define RB_BLOCK -1
#else
#  define RB_POLL   1
#  define RB_BLOCK  0
#endif

/* 
 * Try to do something portable about hardware flow control. Various
 * systems define termios c_cflag bit twiddling to enable rts/cts flow
 * control. Linux defines the CRTSCTS bit mask, while CTSFLOW and 
 * CCTS_OFLOW are defined by SCO and BSD respectively. If your variant
 * defines the c_cflag bits for setting rts/cts flow control, define CRTSCTS
 * to be the bitwise "OR" of the relevant bits on your system. SVR4 users
 * should read termiox(7) in their system manual. Note that there is as
 * yet no portable or POSIX way to set rts/cts flow control.
 */

#if defined(CTSFLOW)  /* SCO */
#define CRTSCTS (CTSFLOW | RTSFLOW)
#elif defined(CCTS_OFLOW) /* BSD */
#define CRTSCTS (CCTS_OFLOW | CRTS_IFLOW)
#endif

#ifdef CRTSCTS        /* Linux and SunOS */ 
#define HAVE_RS232FLOW 1
#else
#undef HAVE_RS232FLOW
#endif

/* 
 * Here we define the prompt style used by xc comm when in its command mode.
 */
#define XCPROMPT "<XC>"

/* 
 * Define the message to use when brain-dead zmodem programs are sent a
 * SIGINT and then don't send the cancel string to other end.
 */

#define BAD_PROGRAM_MSG "WARNING: your file transfer program is brain-dead.\r\n"

/*
 * Define the time-out period in seconds for watch_dog buffer purge.
 */

#if _POSIX_SOURCE
# define XC_WATCH_DOG 30  /* seconds */
#else
# define XC_WATCH_DOG ( 2048 * 5 ) /* characters */
#endif

#if _POSIX_SOURCE || __STDC__
# ifndef P_
# define P_(args) args
# endif
#else
# define const
# define P_(args) ()
#endif

/* globals */
extern int CO, LI, my_escape;
extern short capture, cismode, flowflag, linkflag, reterm, rtscts, y_flag ;
extern short dosmode, delmode, auto_zm, hdplxflag; /* used in xcterm.c */ 
extern short scriptflag ;
extern char captfile[], ddsname[], phonefile[], word[], *wptr, *CE,
  line[], Msg[], *lptr, Name[], protocol[], rzcmd[SM_BUFF], BS ;

extern FILE *tfp;		/* the local terminal */
extern struct termios oldmode, newmode, sigmode;

typedef enum
  {
    ENDCHAR = 256,		/* Higher than any valid keyboard code */
    CAPTYES,
    CAPTEND,
    DIVCHAR,
    DIALCHR,
    HUPCHAR,
    SCRPCHR,
    BRKCHAR,
    HLPCHAR,
    QUITCHR,
    EMITSTR,
    DOSCRPT,
    CLRGRAF,			/* turn off graphics and attributes */
    SENDCAN,
    BADFUNC = 0
  } bindfunc_t;


#ifndef __CEXTRACT__

#if RLINE
extern void rl_initialize P_(( void ));	
char *readline P_(( char *prompt, int scrollflag));
extern void add_history P_(( char *p ));
#endif

extern void B_Transfer P_(( void ));
extern FILE * QueryCreate P_(( short Offer_Resume ));
extern int dial_dir P_(( void ));
extern int redial P_(( void ));
extern void xcdial P_(( char *s ));
extern int main P_(( int argc, char **argv ));
extern void set_onoff P_(( short *flag ));
extern void s_cis P_(( void ));
extern void s_exit P_(( int junk ));
extern void s_set P_(( void ));
extern int s_shell P_(( void ));
extern int hangup P_(( void ));
extern void mattach P_(( void ));
extern int mopen P_(( void ));
extern char * mport P_(( char *s ));
extern unsigned mrate P_(( char *s ));
extern void purge P_(( void ));
extern int readbyte P_(( int seconds ));
extern void sendbyte P_(( int ch ));
extern void send_string P_(( char *s ));
extern void set_rtscts P_(( void ));
extern void unlock_tty P_(( void ));
extern void xc_setflow P_(( short flow ));
extern char * xc_setproto P_(( char *p ));
extern int xmitbrk P_(( void ));
extern void default_bindings P_(( void ));
extern void do_script P_(( char *file ));
extern int get_bound_char P_(( void ));
extern int k_waitfor P_(( long interval, char *fword ));
extern void show_bindings P_(( void ));
extern int beep P_(( void ));
extern void cls P_(( void ));
extern void cl_end P_(( void ));
extern void cl_line P_(( void ));
extern void cur_off P_(( void ));
extern void cur_on P_(( void ));
extern void drawline P_(( int row, int col, int len ));
extern int forkem P_(( void ));
extern void getline P_(( void ));
extern void getword P_(( void ));
extern void get_ttype P_(( void ));
extern FILE * isregfile P_(( char *pathname ));
extern void lc_word P_(( char *ptr ));
extern void mode P_(( int flag ));
extern void msecs P_(( time_t t ));
extern time_t mtime P_(( void ));
extern FILE * openfile P_(( char *name ));
extern void prompt_user P_(( const char *prmp_msg ));
extern void reset_crt P_(( void ));
extern void show P_(( short flag, char *str ));
extern void show_abort P_(( void ));
extern void ttgoto P_(( int row, int col ));
extern void uc_word P_(( char *ptr ));
extern char * unctrl P_(( int c ));
extern char * xc_strdup P_(( const char *s ));
extern void xc_drain P_((int purge_flag));
extern void divert P_(( short script ));
extern void terminal P_(( short todir ));
extern void canit P_(( void ));
extern void xreceive P_(( int c ));
extern void xsend P_(( int c ));
extern void yreceive P_(( int e ));
extern void ysend P_(( void ));

#if DEBUG
extern void dbglog P_((void));
extern int Fprintf P_(( FILE *stream, const char *format, ... ));
extern int Fputc P_(( int   c, FILE *stream ));
extern int Fputs P_(( char *s, FILE *stream ));
#endif /* DEBUG */

#endif /* __CEXTRACT__ */

