#include <stdio.h>
#include <sys/times.h>
#include <unistd.h>
#include <sys/wait.h>
#include <X11/Xlib.h>
#include "xszm.h"
#include "xzm.h"

extern XszData xszData;
extern pid_t panelpid;

int FilePercent, TotalPercent, TotalThruput;
unsigned int FileThruput;
long FileTimeElapsed, TotalTimeElapsed;

extern char Message[MSGARR];
extern int DisplayFlag;

pipeToPanel()
{
  ipcom pipedata;

/* ȭϸ */
  strcpy(pipedata.FileName, xszData.FileName);
/*  ȭ  */
  pipedata.FilesLeft = xszData.nFilesToSend - xszData.nFilesSent 
			- xszData.nFilesError -1; /* -1 means considering the current file sending */
/*    ȭ KB  */
  pipedata.SentFileKB = xszData.nBytesSentOfCurrent/1024;
/*   ü KB  */
  pipedata.SentTotalKB = xszData.nBytesTillNow/1024;
/* ȭ  KB  */
  pipedata.FileBytes = xszData.nFileSize/1024;
/* ü  KB  */
  pipedata.TotalLeft = (xszData.nTotalBytesToSend-xszData.nBytesTillNow)/1024;
/* Thruput  */
  pipedata.Thruput = FileThruput;
/* ȭ   ۼƮ */
  pipedata.FilePercent = FilePercent;
/* ü   ۼƮ */
  pipedata.TotalPercent = TotalPercent;
  pipedata.FileTimeElapsed = (unsigned int) FileTimeElapsed;
  pipedata.TotalTimeElapsed = (unsigned int) TotalTimeElapsed;
  if (FileThruput == 0) 
  {
      pipedata.FileTimeLeft = (unsigned int) 0;
      pipedata.TotalTimeLeft = (unsigned int) 0;
  }
  else 
  {
      pipedata.FileTimeLeft = (unsigned int) 
	((int) xszData.nFileSize - xszData.nFileOffset)/FileThruput;
      if ( pipedata.FilesLeft <= 0 ) 
      {
	  pipedata.TotalTimeLeft = pipedata.FileTimeLeft;
      }
      else
      {
	  pipedata.TotalTimeLeft = (unsigned int) 
		((int) xszData.nTotalBytesToSend - xszData.nBytesTillNow)/FileThruput;
      }
  }
  strcpy(pipedata.Message, Message);
  pipedata.DispFlag = DisplayFlag;

  if(write(panelpipe[1], (char *)&pipedata, sizeof(pipedata)) == -1)
	fprintf(stderr, "Could not write to pipe\n");
}

formatTime(buf, tm)
	 char *buf;
	 unsigned int tm;
{
  char lbuf[20];
  unsigned int idum;
 
  buf[0] = (char) 0;

  idum = tm / 3600;
  if(idum)
    {
	sprintf(lbuf, "%02d:", idum);
	strcat(buf, lbuf);
    }

  idum = (tm % 3600)/60;
  if(idum)
    {
	sprintf(lbuf, "%02d:", idum);
	strcat(buf, lbuf);
    }

  idum = tm % 60;
	sprintf(lbuf, "%02d", idum);
	strcat(buf, lbuf);
}

void waiter()
{
  int wstatus;

  if(wait(&wstatus) != panelpid)
	fprintf(stderr, "Error occured in waiting for child %d\n", 
			(int) panelpid);
  else if(WIFEXITED(wstatus))
	if(WEXITSTATUS(wstatus) == 2) {
	  fprintf(stderr, "xsz: Transfer inturrepted by user\n");
	  bibi(0);
	}
  else {
	fprintf(stderr, "Child %d exited\n", (int) panelpid);
	bibi(0);
  }
}

int xshow_info()
{
  struct tms tdummy;
  long CurTime;

  FilePercent = 100 * xszData.nFileOffset / xszData.nFileSize;
  TotalPercent = 100 * xszData.nBytesTillNow / xszData.nTotalBytesToSend;

  CurTime = times(&tdummy);
  FileTimeElapsed = (CurTime-xszData.StartTimeEach)>100 ? 
			(CurTime-xszData.StartTimeEach)/100 : 1;
  TotalTimeElapsed = (CurTime-xszData.StartTimeTotal)>100 ? 
			(CurTime-xszData.StartTimeTotal)/100 : 1;

  FileThruput = xszData.nBytesTillNow / TotalTimeElapsed;

  zmessage("Sending File Data");
  
}

zmessage(msg)
	 char *msg;
{
  if (strlen(msg) > MSGLEN)
	msg[MSGLEN] = (char) 0;

  strcpy(Message, msg);
  pipeToPanel();
}
