// Copyright (C) 2000 Open Source Telecom Corporation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <syslog.h>
#include <stdlib.h>
#include "server.h"
#include "trunk.h"

void Trunk::Collect(EventRecord *er)
{
	switch(er->event)
	{
	case UM_EVENT_ENTER_STATE:
		collect = atoi(getOption("1"));
		if(digits >= collect)
			break;
		setDTMF();
		setTimer(atoi(getOption(getkeylast(keyaudio, "timer"))) * 1000);
		strncpy(term, getOption(""), 16);
		term[16] = 0;
		strncpy(ignore, getOption(""), 16);
		ignore[16] = 0;
		return;
	case PH_EVENT_DTMF_DIGIT:
		endTimer();
		switch(er->p1)
		{
		case 'a':
			er->p1 = 'A';
			break;
		case 'b':
			er->p1 = 'B';
			break;
		case 'c':
			er->p1 = 'C';
			break;
		case 'd':
			er->p1 = 'D';
			break;
		}

		if(strchr(term, (char)er->p1))
			break;

		if(strchr(ignore, (char)er->p1))
		{
			setTimer(timer);
			return;
		}

		digit[digits++] = er->p1;
		digit[digits] = 0;
		if(digits >= collect)
			break;
		setTimer(timer);
		return;
	case PH_EVENT_TIMER_EXPIRED:
		return scrTimeout();
	default:
		Default(er);
		return;
	}
	scrNext();
}
