// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <debug.h>
#include "server.h"
#include "trunk.h"
#include "session.h"

void Trunk::Default(EventRecord *er)
{
#ifdef	IXJ_DRIVER
	IXJ_CID ixjcid;
#endif

	switch(er->event)
	{
	case PH_EVENT_LINE_RINGING:
		++rings;
		break;
	case PH_EVENT_SERVICE_ENDING:
		if(service)
		{
			delete service;
			service = NULL;
		}
		return;
	case PH_EVENT_CALLER_ID:
		if(offhook)
			return;

		cid[0] = 0;
		switch(driver)
		{
#ifdef	IXJ_DRIVER
		case ixj_driver:
			memset(&ixjcid, 0, sizeof(ixjcid));
			ioctl(device, IXJCTL_CID, &ixjcid);
			setcid();
			if(ixjcid.number[0])
				sprintf(cid + strlen(cid), "&number=%s",
					ixjcid.number);
			if(ixjcid.name[0])
				sprintf(cid + strlen(cid), "&name=%s",
					ixjcid.name);

			strcpy(ani, ixjcid.number);
			debug(3, "caller(%d): %s", id, cid); 
			break;
#endif
		}
		break;
	case UM_EVENT_START_LINE:
		if(er->p1)
			SendMessage(getPhoneTrunk(--er->p1), er);
		break;
	case UM_EVENT_ENTER_STATE:
		endTimer();
		break;
	case UM_EVENT_STOP_STATE:
		return scrExecute();
	case UM_EVENT_MAKE_BUSY:
		setHandler((handler_t)&Trunk::Busy);
		break;
	case PH_EVENT_LINE_WINKING:
		if(exeTrap())
			return;

		if(trap)
			return;

		setHandler((handler_t)&Trunk::Idle);
		debug(1, "line %d; call terminated", id);
		break;
	case UM_EVENT_MAKE_IDLE:
		setHandler((handler_t)&Trunk::Idle);
		break;
	case UM_EVENT_EXIT_SHELL:
		exstatus = er->p1;
		break;
	case UM_EVENT_ERROR_ABORT:
		scrError((char *)er->p2);
		break;
	case PH_EVENT_TIMER_EXPIRED:
	        //debug(2,"default: timeout");
		return scrTimeout();
	case PH_EVENT_DTMF_DIGIT:
	        debug(2,"DTMF %c in default", er->p1);
		switch(er->p1)
		{
		case '0':
			return scrDigit(0);
		case '1':
			return scrDigit(1);
		case '2':
			return scrDigit(2);
		case '3':
			return scrDigit(3);
		case '4':
			return scrDigit(4);
		case '5':
			return scrDigit(5);
		case '6':
			return scrDigit(6);
		case '7':
			return scrDigit(7);
		case '8':
			return scrDigit(8);
		case '9':
			return scrDigit(9);
		case '*':
			return scrDigit(10);
		case '#':
			return scrDigit(11);
		case 'a':
		case 'A':
			return scrDigit(12);
		case 'b':
		case 'B':
			return scrDigit(13);
		case 'c':
		case 'C':
			return scrDigit(14);
		case 'd':
		case 'D':
			return scrDigit(15);
		}
	}
}

