// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include <syslog.h>
#include <stdlib.h>
#include "server.h"
#include "trunk.h"

Dialer::Dialer(Trunk *trk, char *d) : 
Service(trk), Thread((Semaphore *)NULL)
{
	int dtmf_on = atoi(getkeylast(keyphone, "digittimer"));
	int dtmf_off = atoi(getkeylast(keyphone, "interdigittimer"));

	dial = d;

	switch(trk->getDriver())
	{
#ifdef	IXJ_DRIVER
	case ixj_driver:
		ioctl(device, IXJCTL_DSP_IDLE);
		break;
#endif
	}

	ioctl(device, PHONE_SET_TONE_ON_TIME, dtmf_on);
	ioctl(device, PHONE_SET_TONE_OFF_TIME, dtmf_off);
}

Dialer::~Dialer()
{
	Terminate();
	ioctl(device, PHONE_PLAY_STOP);
}

void Dialer::Run(void)
{
	char digit;
	setCancel(THREAD_CANCEL_IMMEDIATE);

	while(*dial)
	{
		digit = 0x7f;
		switch(*dial)
		{
		case 'a':
		case 'A':
			digit = 28;
			break;
		case 'b':
		case 'B':
			digit = 29;
			break;
		case 'c':
		case 'C':
			digit = 30;
			break;
		case 'd':
		case 'D':
			digit = 31;
			break;
		case '*':
			digit = 11;
			break;
		case '#':
			digit = 12;
			break;
		case '0':
			digit = 10;
			break;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			digit = *dial - '0';
			break;
		}
		++dial;
		if(digit == 0x7f)
			continue;
		ioctl(device, PHONE_PLAY_TONE, digit);
		while(ioctl(device, PHONE_GET_TONE_STATE))
			Sleep(40);				
	}
	endService();
}

void Trunk::Dial(EventRecord *er)
{
	char *dial;

	switch(er->event)
	{
	case UM_EVENT_ENTER_STATE:
		if(!offhook)
		{
			ioctl(device, PHONE_PSTN_SET_STATE, PSTN_ON_HOOK);
			time(&starttime);
			offhook = true;
		}
		dial = getOption(NULL);
		if(!dial)
			break;
		endDTMF();
		if(service)
			delete service;
		service = (Thread *)new Dialer(this, dial);
		service->Start();
		return;
	case PH_EVENT_SERVICE_ENDING:
		delete service;
		service = NULL;
		break;
	default:
		Default(er);
		return;
	}
	scrNext();
}
