// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <assert.h>
#include <config.h>
#include "server.h"
#include "trunk.h"
#include "session.h"

static int port_count = 0;
static MappedFile *runfile = NULL;
static Session *session = NULL;

int getDriverPorts(void)
{
	return port_count;
}

int initDriver(char *scr, int first, int lines, int pri)
{
	int count = 0;
	int trunk = 0;
	int fd;
	char devname[33];

	// set up run maps

	File rundata(getkeyfirst(keypaths, "runfile"), FILE_OPEN_TRUNCATE, 0640);
	Runmap runmap, *map;
	memset(&runmap, 0, sizeof(runmap));
	strcpy(runmap.current, "INITIALIZING...");
	strcpy(runmap.schedule, "default");

	for(trunk = 0; trunk < lines; ++trunk)
		write(rundata, &runmap, sizeof(runmap));

	runfile = new MappedFile(getkeyfirst(keypaths, "runfile"), 0, sizeof(runmap) * lines, FILE_MAPPED_RDWR);
 
	if(!runfile)
	{
		throw(lines);
		return -1;
	}

	// set up trunks

	session = (Session *)new Session(lines, pri);

	for(trunk = 0; trunk < lines; ++trunk)
	{
		sprintf(devname, "%s%d", getkeylast(keyphone, "prefix"),
			trunk + first);
		fd = open(devname, O_RDWR);
		if(fd < 0)
			continue;

 		map = (Runmap *)runfile->Fetch(trunk * sizeof(runmap));
		Session::trunks[count++] = new Trunk(map, scr, fd, session);
	}
	syslog(LOG_NOTICE, "%d trunk ports active", count);
	port_count = count;

	if(session)
		session->Start();

	return 0;
}

int stopDriver(void)
{
	int trunk = 0;

	if(session)
		session->Update(0);

	// delete turnks
	while(Session::trunks && trunk < port_count)
		delete Session::trunks[trunk++];

	if(session)
		delete session;

	return 0;
}

