// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <syslog.h>
#include <stdlib.h>
#include "server.h"
#include "trunk.h"

void Trunk::ExWait(EventRecord *er)
{
	int timer;
	char *arg;
	switch(er->event)
	{
	case UM_EVENT_EXIT_SHELL:
		Default(er);
		endTimer();
		break;
	case UM_EVENT_ENTER_STATE:
		if(exstatus != -1)
			break;

		timer = atoi(getOption("1"));
		if(timer < 1)
			timer = 1;

		setTimer(timer * 1000);
		return;
	case PH_EVENT_TIMER_EXPIRED:
		endTimer();
		return scrTimeout();
	default:
		Default(er);
		return;
	}
	scrNext();
}
