// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <debug.h>
#include "server.h"
#include "trunk.h"

void Trunk::Idle(EventRecord *er)
{
	int	rtn;
	
	switch(er->event)
	{
	case UM_EVENT_ENTER_STATE:
		cid[0] = 0;
		ani[0] = 0;
		dnid[0] = 0;

	        debug(2, "Idle(%d): enter state as %d", id,
			ioctl(device, PHONE_PSTN_GET_STATE));
		endTimer();
		endDTMF();
		resetAudio();
		ioctl(device, PHONE_PSTN_SET_STATE, PSTN_ON_HOOK);		
		offhook = false;
		idle = true;
		trap = false;
		rings = 0;
		resetThreads();
		time(&idletime);
		setCurrent("IDLE");
		scrDetach();
		break;
	
	case UM_EVENT_START_LINE:
		time(&ringtime);
		setcid();
		idle = offhook = false;
		scrAttach((char *)er->p2);
		break;

	case PH_EVENT_LINE_RINGING:
		++rings;
	case UM_EVENT_RING_LINE:
		time(&ringtime);
		setcid();
	        debug(2, "Idle(%d): RING", id);
		idle = offhook = false;
		scrAttach(NULL);
		break;

//	The Quicknet card also picks up caller id events when the line
//	is idle and someone is talking on the phone.  For this reason
//	we throw out idle CALLER_ID events...

	case PH_EVENT_CALLER_ID:
		break;

	case UM_EVENT_MAKE_IDLE:
		break;

	default:
		Default(er);
	}
}



