// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <syslog.h>
#include <stdlib.h>
#include <aufile.h>
#include "server.h"
#include "trunk.h"

Recorder::Recorder(Trunk *trk, char *path) :
Service(trk), Thread((Semaphore *)NULL)
{
	fd = -1;
	strcpy(pathname, path);
}

Recorder::~Recorder()
{
	Terminate();
	if(fd > -1)
		close(fd);
	ioctl(device, PHONE_REC_STOP);
}

void Recorder::Initial(void)
{
	int count = 0;
	int codec;
	int framing;
	int len;
	char *cp;
	char *ext = strrchr(pathname, '.');
	AUFILE au;
	int vol = trunk->getRecordVolume() * 10;

	ioctl(device, PHONE_REC_VOLUME, vol);
	fd = open(pathname, O_WRONLY | O_CREAT | O_TRUNC, 0660);
	setCancel(THREAD_CANCEL_IMMEDIATE);
	if(fd < 0)
	{
		syslog(LOG_ERR, "%s: cannot record", pathname);
		endService();
	}

	if(!stricmp(ext, ".au"))
	{
		setaulong(au.magic, AU_FILE_MAGIC);
		setaulong(au.hdrsize, 24);
		setaulong(au.datasize, AU_SIZE_UNKNOWN);
		setaulong(au.encoding, AU_ENCODING_MULAW);
		setaulong(au.sampling, 8000);
		setaulong(au.channels, 1);
		write(fd, &au, 24);
	} 

	if(!stricmp(ext, ".ul") || !stricmp(ext, ".au"))
	{
		codec = ULAW;
		framing = 20;
		len = 80;
	}

	if(!stricmp(ext, ".al"))
	{
		codec = ALAW;
		framing = 20;
		len = 80;
	}

	cp = getkeylast(keyphone, "depth");
	if(cp)
		ioctl(device, PHONE_REC_DEPTH, atoi(cp));

	switch(trunk->getDriver())
	{
	case ixj_driver:
		if(framing == 20)
			framing = 30;
		break;
	}

	while(frame != ioctl(device, PHONE_FRAME, frame) && count < 5)
		Sleep(20);

	if(count > 4)
	{
		syslog(LOG_ERR, "codec(%d): cannot set frame size", codec);
		endService();
	}

	if(ioctl(device, PHONE_REC_CODEC, codec))
	{
		syslog(LOG_ERR, "codec(%d): unavailable", codec);
		endService();
	}

	frame = (framing / 10) * len;
	ioctl(device, PHONE_REC_START);
}

void Recorder::Run(void)
{
	char buffer[frame];

	while(frame == ::read(device, buffer, frame))
	{
		if(frame != ::write(fd, buffer, frame))
			break;
	}
	endService();
}

void Trunk::Record(EventRecord *er)
{
	int rtn;
	char *fn;
	char pathname[128];
	char *cp;
	
	switch(er->event)
	{
	case PH_EVENT_SERVICE_ENDING:
		break;
	case PH_EVENT_TIMER_EXPIRED:
		return scrTimeout();
	case UM_EVENT_STOP_STATE:
		endTimer();
		if(service)
		{
			delete service;
			service = NULL;
		}
		return scrExecute();

	case UM_EVENT_ENTER_STATE:
		if(!offhook)
		{
			ioctl(device, PHONE_PSTN_SET_STATE, PSTN_OFF_HOOK);
			time(&starttime);
			offhook = true;
		}

		setDTMF();
		fn = getOption(NULL);
		if(!fn)
			break;
		setTimer(atoi(getOption(getkeyfirst(keyaudio, "timer"))) * 1000);
		strncpy(term, getOption(""), 16);
		term[16] = 0;

		// set up file name

		if (strchr(fn, '/'))
			pathname[0] = 0;
		else 
		{
		  	strcpy(pathname, getkeylast(keypaths, "prompts"));
		  	strcat(pathname, "/");
		}
		strcat(pathname, fn);
		cp = strrchr(pathname, '/');
		cp = strrchr(cp, '.');
		if(!cp)
			strcat(pathname, ".ul");
		service = new Recorder(this, pathname);
		service->Start();
		return;

	case PH_EVENT_DTMF_DIGIT:
		if(strchr(term, (char)er->p1))
		{
			endTimer();
			break;
		}	
	default:
		Default(er);
		return;
	}
	if(service)
	{
		delete service;
		service = NULL;
	}
	scrNext();
}










