// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <aufile.h>

class Audio : public Thread, public Semaphore
{
private:
	unsigned char filler;
	int bufsize;
	char *buffer;
	int buffers;

protected:
	TResourceHandle hDsp;
	TBufferHeader *ctrl;
	char pathname[128];
	long offset;
	bool idle;
	AUFILE	aufile;
	
	int frames;
	int fd;

	int Empty(int frame, unsigned flag);
	int Fill(int frame, int size, unsigned flag);
	int Silent(int frame);
	void setFormat(int format = AU_ENCODING_MULAW, int speed = AU_SAMPLING_8khz); 

	inline bool hasFormat(void)
		{return (buffer != NULL);};

	inline char *getFrameData(int frame)
		{return buffer + frame * buffers * bufsize;};

	inline int getFrameSize(void)
		{return bufsize * buffers;};

	inline int getBufferSize(void)
		{return bufsize;};

public:
	Audio(TResourceHandle dsp, char *fname, long offset = 0);
	virtual ~Audio();

	virtual bool PlayBuffer(void)
		{return false;};

	virtual bool RecordBuffer(void)
		{return false;};

	inline long getOffset(void)
		{return offset;};
};

class RecordAudio : public Audio
{
private:
	bool recording, newfile;
	long total;
	int framepos;

protected:
	void Save(int frame, bool override);
	void Initial(void);
	void Run(void);

public:
	RecordAudio(TResourceHandle dsp, char *fname, long offset = 0);
	~RecordAudio();

	inline bool RecordBuffer(void);
};

class PlayAudio : public Audio
{
private:
	long total, loaded;

protected:
	void Silent(int frame);
	void Load(int frame);
	void Initial(void);
	void Run(void);

public:
	PlayAudio(TResourceHandle dsp, char *fname, long offset = 0);
	~PlayAudio();

	inline bool PlayBuffer(void);
};

