// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ACS as noted here.
//
// This exception is that permission is hereby granted to link ACS with
// the Pika MonteCarlo static libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name ACS.  If you copy code from other releases into a copy of
// ACS, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to ACS, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include <config.h>
#include "server.h"
#include "pika.h"

static char *names[] =
{
	"Unknown",
	"V12",
	"Daytona",
	"Premiere",
	"Trans4M",
	"DSP Module",
	"InLine GT",
	"InLine GTB",
	"InLine EX",
	"InLine ST",
	"PrimeNet",
	"Daytona PCI",
	"Primiere PCI",
	"PrimeNet PCI"
}; 

PKCard	*PKCard::first = NULL;
PKCard	*PKCard::last = NULL;
PKCard	*PKCard::lastdsp = NULL;
int	PKCard::cards = 0;
int	PKCard::trunks = 0;
int	PKCard::devices = 0;

PKCard::PKCard()
{
	char name[33];
	int dsp;

	id = cards++;

	if(!first)
		first = last = lastdsp = this;
	else
	{
		last->next = this;
		last = this;
	}
	next = NULL;

// PIKA unsupported
//	if(cards > PIKA_NumberOfBoards())

	if(cards > PK_CTI_NumberOfBoards())
	{
		--cards;
		throw(this);
		return;
	}

	getname(name);

// PIKA unsupported
//	hCard = PIKA_InitializeBoard(id);
//	if(!hCard)
//		throw(this);

	if(PK_CTI_Reset(id))
		throw(this);

	if(PK_DSP_Reset(id))
		throw(this);

	if(PK_CTI_Initialize(id))
		throw(this);

// replaced

	if(PK_MVIP_Initialize(id))
		throw(this);

	if(PK_DSP_Initialize(id))
		throw(this);
	
	active = true;
	trktype = PK_LS_PORT;

// PIKA unsupported
//	trkcount = PIKA_NumberOfPortsOfType(hCard, PK_LS_PORT);
//	if(trkcount)
//		trktype = PK_LS_PORT;
//	else
//		trkcount = PIKA_NumberOfPortsOfType(hCard, PK_DID_PORT);
//	if(trkcount)
//		trktype = PK_DID_PORT;
//	else
//		trkcount = PIKA_NumberOfPortsOfType(hCard, PK_DIGITAL_PORT);
//	if(trkcount)
//		trktype = PK_DIGITAL_PORT;
	trkcount = PK_TRUNK_NumberOfTrunks(id);

	trunks += trkcount;	
	dspcount = PK_DSP_NumberOfDevices(id);
	trkused = dspused = 0;
	dspdevice = NULL;
	devices += dspcount;
	syslog(LOG_INFO, "starting card %d; %d port %s with %d dsp device(s)", 
		id, PK_TRUNK_NumberOfTrunks(id), name, dspcount);

	if(dspcount)
		dspcard = lastdsp = this;
	else
		dspcard = lastdsp;
}

PKCard::~PKCard()
{
	if(active)
	{
// PIKA unsupported
//		PIKA_StopDriver(hCard);
		PK_DSP_StopDriver(id);
		PK_CTI_StopDriver(id);
// replaced
		PK_MVIP_StopDriver(id);
		syslog(LOG_INFO, "stopped card %d", id);
	}
}

char *PKCard::getname(char *buf)
{
	// PK_WORD ctype = PK_CTI_BoardType(id & ~0x1000000);
	PK_WORD ctype = PK_CTI_BoardType(id & ~0x1000000);
	if (ctype < (sizeof(names) / sizeof(char *)))
		strcpy(buf, names[ctype]);
	else
		strcpy(buf, "invalid");
	return buf;
}

void stopPika(void)
{
	PKCard	*card = PKCard::first;

	while(card)
	{
// PIKA unsupported
//		PIKA_StopDriver(card->hCard);
		PK_DSP_StopDriver(card->id);
		PK_CTI_StopDriver(card->id);
// replaced
		PK_MVIP_StopDriver(card->id);
		syslog(LOG_INFO, "stopped card %d", card->id);
		card->active = false;
		card = card->next;
	}
};

PKCard *getTrunkCard(PK_WORD tag)
{
	PKCard *card = PKCard::first;

	while(card)
	{
		if(card->trkused < card->trkcount)
		{
			if(!tag || tag == card->trktype)
				break;
		}
		card = card->next;
	}
	return card;
}

// PIKA unsupported	
// TPortHandle seizeTrunkPort(PKCard *card)
// {
// 	++card->trkused;
// 	return PIKA_SeizePortHandle(card->hCard);
// }

// PIKA unsupported
// void releaseTrunkPort(PKCard *card, TPortHandle port)
// {
// 	--card->trkused;
// 	PIKA_ReleasePort(port);
// }

void setPikaTrunks(int lines)
{
	if(!lines)
		return;

	if(lines > PKCard::trunks)
		lines = PKCard::trunks;

	PKCard::trunks = lines;
}
